/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.items.tools.MalachiteCrossbowItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.OverchargingSoundInstance;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlassCrestCrossbowItem
extends MalachiteCrossbowItem
implements ExtendedItemBar,
SlotBackgroundEffect,
InkPowered {
    private static final InkCost OVERCHARGE_COST = new InkCost(InkColors.WHITE, 1000L);
    private static final int OVERCHARGE_DURATION_MAX_TICKS = 120;

    public GlassCrestCrossbowItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(OVERCHARGE_COST.color());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        if (user.isShiftKeyDown() && GlassCrestCrossbowItem.isCharged((ItemStack)itemStack) && !GlassCrestCrossbowItem.isOvercharged(itemStack) && InkPowered.tryDrainEnergy(user, OVERCHARGE_COST)) {
            if (world.isClientSide) {
                this.startSoundInstance(user);
            }
            return ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
        }
        return super.use(world, user, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSoundInstance(Player user) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new OverchargingSoundInstance(user));
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return GlassCrestCrossbowItem.isCharged((ItemStack)stack) ? 120 : super.getUseDuration(stack, user);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (GlassCrestCrossbowItem.isCharged((ItemStack)stack) && remainingUseTicks <= 0) {
            if (remainingUseTicks % 4 == 0) {
                world.playSound(null, (Entity)user, PastelSounds.BLOCK_MOONSTONE_CLUSTER_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            super.onUseTick(world, user, stack, remainingUseTicks);
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (GlassCrestCrossbowItem.isCharged((ItemStack)stack)) {
            if (!world.isClientSide && remainingUseTicks > 0) {
                float overcharge = 1.0f - (float)remainingUseTicks / 120.0f;
                GlassCrestCrossbowItem.overcharge(stack, overcharge);
                if (user instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)user;
                    serverPlayerEntity.displayClientMessage((Component)Component.translatable((String)"item.pastel.glass_crest_crossbow.message.charge", (Object[])new Object[]{Support.DF.format(overcharge * 100.0f)}), true);
                }
            }
            return;
        }
        super.releaseUsing(stack, world, user, remainingUseTicks);
    }

    public static boolean isOvercharged(ItemStack stack) {
        return GlassCrestCrossbowItem.getOvercharge(stack) > 0.0f;
    }

    public static float getOvercharge(ItemStack stack) {
        return ((Float)stack.getOrDefault(PastelDataComponentTypes.OVERCHARGED, (Object)Float.valueOf(0.0f))).floatValue();
    }

    public static void overcharge(ItemStack stack, float percent) {
        stack.set(PastelDataComponentTypes.OVERCHARGED, (Object)Float.valueOf(percent));
    }

    public static void unOvercharge(ItemStack stack) {
        stack.remove(PastelDataComponentTypes.OVERCHARGED);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(stack);
        if (overcharge == 0.0f) {
            tooltip.add((Component)Component.translatable((String)"item.pastel.glass_crest_crossbow.tooltip.how_to_overcharge").withStyle(ChatFormatting.GRAY));
            this.addInkPoweredTooltip(tooltip);
        } else {
            tooltip.add((Component)Component.translatable((String)"item.pastel.glass_crest_crossbow.tooltip.overcharged", (Object[])new Object[]{Support.DF.format(overcharge * 100.0f)}).withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public float getProjectileVelocityModifier(ItemStack stack) {
        float parent = super.getProjectileVelocityModifier(stack);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(stack);
        return overcharge == 0.0f ? parent : parent * (1.0f + overcharge * 0.75f);
    }

    @Override
    public float getDivergenceMod(ItemStack stack) {
        float parent = super.getDivergenceMod(stack);
        float overcharge = GlassCrestCrossbowItem.getOvercharge(stack);
        return overcharge == 0.0f ? parent : parent * (1.0f - overcharge * 0.5f);
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        boolean usable = InkPowered.hasAvailableInk(player, OVERCHARGE_COST);
        return usable ? SlotBackgroundEffect.SlotEffect.BORDER_FADE : SlotBackgroundEffect.SlotEffect.NONE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return 0xFFFFFF;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean allowVanillaDurabilityBarRendering(@Nullable Player player, ItemStack stack) {
        if (player == null || !GlassCrestCrossbowItem.isCharged((ItemStack)stack)) {
            return true;
        }
        boolean usage = player.isUsingItem() && player.getItemInHand(player.getUsedItemHand()) == stack;
        return !usage && !GlassCrestCrossbowItem.isOvercharged(stack);
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        boolean usage;
        if (player == null || !GlassCrestCrossbowItem.isCharged((ItemStack)stack)) {
            return PASS;
        }
        boolean bl = usage = player.isUsingItem() && player.getItemInHand(player.getUsedItemHand()) == stack;
        if (!usage && !GlassCrestCrossbowItem.isOvercharged(stack)) {
            return PASS;
        }
        int progress = (int)Math.floor(Mth.clampedLerp((float)0.0f, (float)13.0f, (float)(usage ? (float)player.getTicksUsingItem() / 120.0f : GlassCrestCrossbowItem.getOvercharge(stack))));
        return new ExtendedItemBar.BarSignature(2, 13, 13, progress, 1, -1, 2, -16777216);
    }
}

