/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.tools;

import earth.terrarium.pastel.api.item.MergeableItem;
import earth.terrarium.pastel.api.item.SlotReservingItem;
import earth.terrarium.pastel.api.item.SplitDamageHandler;
import earth.terrarium.pastel.api.render.SlotBackgroundEffect;
import earth.terrarium.pastel.entity.entity.DragonTalonEntity;
import earth.terrarium.pastel.items.tools.MalachiteBidentItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelEntityAttributes;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class DragonTalonItem
extends MalachiteBidentItem
implements MergeableItem,
SlotReservingItem,
SlotBackgroundEffect {
    private final ItemAttributeModifiers modifiers;

    public DragonTalonItem(Tier toolMaterial, double damage, double extraReach, Item.Properties settings) {
        super(settings, 0.0, 0.0, 0.0f, 0.0f);
        this.modifiers = ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, damage + (double)toolMaterial.getAttackDamageBonus(), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(PastelEntityAttributes.REACH_MODIFIER_ID, extraReach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.pastel.dragon_talon.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.dragon_talon.tooltip2").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.dragon_talon.tooltip3").withStyle(ChatFormatting.GRAY));
    }

    @Override
    public float getThrowSpeed(ItemStack stack) {
        return 3.5f;
    }

    @Override
    protected void throwBident(ItemStack stack, ServerLevel world, Player playerEntity) {
        DragonTalonEntity needleEntity = new DragonTalonEntity((Level)world);
        needleEntity.setPickupItemStack(stack);
        needleEntity.setOwner((Entity)playerEntity);
        needleEntity.absMoveTo(playerEntity.getX(), playerEntity.getEyeY() - 0.1, playerEntity.getZ());
        needleEntity.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, this.getThrowSpeed(stack), 1.0f);
        needleEntity.hasImpulse = true;
        needleEntity.hurtMarked = true;
        needleEntity.pickup = AbstractArrow.Pickup.ALLOWED;
        world.addFreshEntity((Entity)needleEntity);
        SoundEvent soundEvent = (SoundEvent)SoundEvents.TRIDENT_THROW.value();
        world.playSound(null, (Entity)needleEntity, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
        SlotReservingItem.reserve(stack, needleEntity.getUUID());
    }

    @Override
    public ItemStack getMergeResult(ServerPlayer player, ItemStack firstHalf, ItemStack secondHalf) {
        int durability = Math.max(firstHalf.getDamageValue(), secondHalf.getDamageValue());
        ItemStack result = new ItemStack((ItemLike)PastelItems.DRACONIC_TWINSWORD.get());
        result.applyComponents(firstHalf.getComponents());
        result.remove(PastelDataComponentTypes.PAIRED_ITEM);
        result.remove(DataComponents.ATTRIBUTE_MODIFIERS);
        SlotReservingItem.free(result);
        if (SlotReservingItem.isReservingSlot(firstHalf) || SlotReservingItem.isReservingSlot(secondHalf)) {
            durability += player.getAbilities().instabuild ? 0 : 500;
            player.getCooldowns().addCooldown(result.getItem(), 400);
        }
        result.setDamageValue(Math.min(durability, firstHalf.getMaxDamage() - 1));
        return result;
    }

    @Override
    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        InteractionHand hand = user.getUsedItemHand();
        if (hand == InteractionHand.MAIN_HAND) {
            return;
        }
        if (!SlotReservingItem.isReservingSlot(stack)) {
            super.releaseUsing(user.getItemInHand(InteractionHand.OFF_HAND), world, user, remainingUseTicks);
            return;
        }
        UUID reserver = SlotReservingItem.getReserver(stack);
        if (world instanceof ServerLevel) {
            Entity entity;
            ServerLevel serverWorld = (ServerLevel)world;
            if (reserver != null && (entity = serverWorld.getEntity(reserver)) instanceof DragonTalonEntity) {
                DragonTalonEntity needle = (DragonTalonEntity)entity;
                needle.recall();
            }
        }
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) && !SlotReservingItem.isReservingSlot(stack);
    }

    @Override
    public boolean canMerge(ServerPlayer player, ItemStack parent, ItemStack other) {
        if (player.getCooldowns().isOnCooldown(parent.getItem())) {
            return false;
        }
        return parent.getItem() == other.getItem() && this.verify(parent, other);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.fail((Object)user.getItemInHand(hand));
        }
        return super.use(world, user, hand);
    }

    @Override
    public void playSound(ServerPlayer player) {
        player.playNotifySound(PastelSounds.METALLIC_UNSHEATHE, SoundSource.PLAYERS, 0.5f, 0.8f + player.getRandom().nextFloat() * 0.4f);
    }

    public static ItemStack findThrownStack(Player player, UUID id) {
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!SlotReservingItem.isReserver(stack, id)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getCooldowns().isOnCooldown(stack.getItem()) || SlotReservingItem.isReservingSlot(stack)) {
                stack.remove(DataComponents.ATTRIBUTE_MODIFIERS);
            } else {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)this.modifiers);
            }
        }
    }

    @Override
    public SplitDamageHandler.DamageComposition getDamageComposition(LivingEntity attacker, LivingEntity target, ItemStack stack, float damage) {
        SplitDamageHandler.DamageComposition composition = new SplitDamageHandler.DamageComposition();
        composition.add(PastelDamageTypes.evisceration(attacker.level(), (Entity)attacker), damage);
        return composition;
    }

    @Override
    public Map<ResourceKey<Enchantment>, Integer> getDefaultEnchantments() {
        return Map.of();
    }

    @Override
    public float getDefenseMultiplier(LivingEntity target, ItemStack stack) {
        return 1.0f;
    }

    @Override
    public SlotBackgroundEffect.SlotEffect backgroundType(@Nullable Player player, ItemStack stack) {
        return SlotBackgroundEffect.SlotEffect.BORDER_FADE;
    }

    @Override
    public int getBackgroundColor(@Nullable Player player, ItemStack stack, float tickDelta) {
        return -1184512;
    }

    @Override
    public void expandTooltipPostStats(ItemStack stack, @Nullable Player player, List<Component> tooltip, Item.TooltipContext context) {
    }

    @Override
    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.CHANNELING) || enchantment.is(Enchantments.PIERCING) || enchantment.is(PastelEnchantments.INERTIA);
    }
}

