/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.magic_items;

import earth.terrarium.pastel.api.energy.InkCost;
import earth.terrarium.pastel.api.energy.InkPowered;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.interaction.NaturesStaffTriggered;
import earth.terrarium.pastel.compat.claims.GenericClaimModsCompat;
import earth.terrarium.pastel.data_loaders.NaturesStaffConversionDataLoader;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.interaction.InventoryHelper;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelBlockTags;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelSounds;
import earth.terrarium.pastel.sound.NaturesStaffUseSoundInstance;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class NaturesStaffItem
extends Item
implements InkPowered {
    public static final ItemStack ITEM_COST = new ItemStack((ItemLike)PastelItems.VEGETAL.get(), 1);
    public static final InkCost INK_COST = new InkCost(InkColors.LIME, 20L);

    public NaturesStaffItem(Item.Properties settings) {
        super(settings);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        int efficiencyLevel = Ench.getLevel(context.registries(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, stack);
        if (efficiencyLevel == 0) {
            if (InkPowered.canUseClient()) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.natures_staff.tooltip_with_ink", (Object[])new Object[]{INK_COST.color().getColoredInkName()}));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.natures_staff.tooltip"));
            }
        } else {
            int chancePercent = (int)(this.getInkCostMod(context.registries(), stack) * 100.0f);
            if (InkPowered.canUseClient()) {
                tooltip.add((Component)Component.translatable((String)"item.pastel.natures_staff.tooltip_with_ink_and_chance", (Object[])new Object[]{INK_COST.color().getColoredInkName(), chancePercent}));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.pastel.natures_staff.tooltip_with_chance", (Object[])new Object[]{chancePercent}));
            }
        }
        tooltip.add((Component)Component.translatable((String)"item.pastel.natures_staff.tooltip_lure"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (NaturesStaffItem.canUse(user)) {
            if (world.isClientSide) {
                this.startSoundInstance(user);
            }
            ItemUtils.startUsingInstantly((Level)world, (Player)user, (InteractionHand)hand);
        }
        return super.use(world, user, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startSoundInstance(Player user) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)new NaturesStaffUseSoundInstance(user));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 20000;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        HitResult hitResult;
        if (remainingUseTicks % 10 != 0) {
            return;
        }
        if (!(user instanceof Player)) {
            user.releaseUsingItem();
            return;
        }
        Player player = (Player)user;
        if (!NaturesStaffItem.canUse(player)) {
            user.releaseUsingItem();
        }
        if (!world.isClientSide && (hitResult = Support.playerBlockInteractionRaycast(world, user, player)).getType() == HitResult.Type.BLOCK) {
            this.useOn(new UseOnContext(world, player, player.getUsedItemHand(), player.getItemInHand(player.getUsedItemHand()), (BlockHitResult)hitResult));
        }
    }

    public float getInkCostMod(HolderLookup.Provider lookup, ItemStack itemStack) {
        return 3.0f / (3.0f + (float)Ench.getLevel(lookup, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, itemStack));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Player user = context.getPlayer();
        if (user == null) {
            return InteractionResult.FAIL;
        }
        if (world.isClientSide) {
            if (NaturesStaffItem.canUse(user)) {
                return InteractionResult.PASS;
            }
            this.playDenySound(world, user);
            return InteractionResult.FAIL;
        }
        if (user.getTicksUsingItem() < 2) {
            return InteractionResult.PASS;
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            ItemStack stack = context.getItemInHand();
            BlockPos blockPos = context.getClickedPos();
            if (!GenericClaimModsCompat.canInteract(world, blockPos, (Entity)user)) {
                this.playDenySound(world, context.getPlayer());
                return InteractionResult.FAIL;
            }
            if (user.getTicksUsingItem() % 10 == 0) {
                NaturesStaffTriggered naturesStaffTriggered;
                NaturesStaffItem.spawnParticlesAndEffect(world, context.getClickedPos());
                boolean success = false;
                BlockState sourceState = world.getBlockState(blockPos);
                Block block = sourceState.getBlock();
                if (block instanceof NaturesStaffTriggered && (naturesStaffTriggered = (NaturesStaffTriggered)block).canUseNaturesStaff(world, blockPos, sourceState)) {
                    if (naturesStaffTriggered.onNaturesStaffUse(world, blockPos, sourceState, (Player)player)) {
                        success = true;
                    }
                } else {
                    BlockState destinationState = NaturesStaffConversionDataLoader.getConvertedBlockState(sourceState.getBlock());
                    if (destinationState != null) {
                        if (destinationState.getBlock() instanceof SimpleWaterloggedBlock) {
                            destinationState = NaturesStaffItem.touchesWater(world, blockPos) ? (BlockState)destinationState.setValue((Property)CoralPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : (BlockState)destinationState.setValue((Property)CoralPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
                        }
                        world.setBlock(blockPos, destinationState, 3);
                        this.payForUse((Player)player, stack);
                        success = true;
                    } else if (sourceState.is(PastelBlockTags.NATURES_STAFF_STACKABLE)) {
                        BlockState state;
                        int i = 0;
                        do {
                            state = world.getBlockState(context.getClickedPos().above(i));
                            ++i;
                        } while (state.is(sourceState.getBlock()));
                        BlockPos targetPos = context.getClickedPos().above(i - 1);
                        if (this.tryPlaceBlock(sourceState, world, targetPos, Direction.DOWN, Direction.UP)) {
                            success = true;
                        }
                    } else if (sourceState.is(PastelBlockTags.NATURES_STAFF_SPREADABLE)) {
                        RandomSource random = world.getRandom();
                        for (int i = 0; i < 5; ++i) {
                            BlockPos randomOffsetPos = blockPos.offset(random.nextIntBetweenInclusive(-3, 3), random.nextIntBetweenInclusive(-3, 3), random.nextIntBetweenInclusive(-3, 3));
                            if (!this.tryPlaceBlock(sourceState, world, randomOffsetPos, Direction.getRandom((RandomSource)random), Direction.getRandom((RandomSource)random))) continue;
                            success = true;
                            break;
                        }
                    } else if (sourceState.isRandomlyTicking() && sourceState.is(PastelBlockTags.NATURES_STAFF_TICKABLE)) {
                        if (world instanceof ServerLevel) {
                            sourceState.randomTick((ServerLevel)world, blockPos, world.random);
                        }
                        success = true;
                    } else if (BoneMealItem.growCrop((ItemStack)Items.BONE_MEAL.getDefaultInstance(), (Level)world, (BlockPos)blockPos)) {
                        success = true;
                    } else if (sourceState.isFaceSturdy((BlockGetter)world, blockPos, context.getClickedFace()) && BoneMealItem.growWaterPlant((ItemStack)Items.BONE_MEAL.getDefaultInstance(), (Level)world, (BlockPos)blockPos.relative(context.getClickedFace()), (Direction)context.getClickedFace())) {
                        success = true;
                    }
                }
                if (success) {
                    this.payForUse((Player)player, stack);
                    PastelCriteria.NATURES_STAFF_USE.trigger(player, sourceState, world.getBlockState(blockPos));
                    return InteractionResult.CONSUME;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private boolean tryPlaceBlock(BlockState blockState, Level world, BlockPos pos, Direction facing, Direction side) {
        BlockState targetState = blockState.getBlock().getStateForPlacement((BlockPlaceContext)new DirectionalPlaceContext(world, pos, facing, ItemStack.EMPTY, side));
        if (targetState != null && world.getBlockState(pos).canBeReplaced() && !world.isOutsideBuildHeight(pos.getY()) && targetState.canSurvive((LevelReader)world, pos)) {
            world.setBlockAndUpdate(pos, targetState);
            world.levelEvent(null, 2001, pos, Block.getId((BlockState)targetState));
            world.playSound(null, pos, targetState.getSoundType().getPlaceSound(), SoundSource.PLAYERS, 1.0f, 0.9f + world.getRandom().nextFloat() * 0.2f);
            world.levelEvent(1505, pos, 15);
            return true;
        }
        return false;
    }

    private static boolean touchesWater(Level world, BlockPos blockPos) {
        return world.getFluidState(blockPos.north()).is(FluidTags.WATER) || world.getFluidState(blockPos.east()).is(FluidTags.WATER) || world.getFluidState(blockPos.south()).is(FluidTags.WATER) || world.getFluidState(blockPos.west()).is(FluidTags.WATER);
    }

    private static void spawnParticlesAndEffect(Level world, BlockPos blockPos) {
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(PastelBlockTags.NATURES_STAFF_STACKABLE)) {
            int i = 0;
            while (world.getBlockState(blockPos.above(i)).is(blockState.getBlock())) {
                world.levelEvent(1505, blockPos.above(i), 15);
                ++i;
            }
            world.levelEvent(1505, blockPos, 15);
            BoneMealItem.addGrowthParticles((LevelAccessor)world, (BlockPos)blockPos.above(i + 1), (int)5);
            int j = 1;
            while (world.getBlockState(blockPos.below(j)).is(blockState.getBlock())) {
                world.levelEvent(1505, blockPos.below(j), 15);
                ++j;
            }
        } else {
            world.levelEvent(1505, blockPos, 15);
        }
    }

    private boolean payForUse(Player player, ItemStack stack) {
        boolean paid = player.isCreative();
        if (!paid) {
            paid = InkPowered.tryDrainEnergy(player, INK_COST, this.getInkCostMod((HolderLookup.Provider)player.level().registryAccess(), stack));
        }
        if (!paid && player.getInventory().contains(ITEM_COST)) {
            int efficiencyLevel = Ench.getLevel((HolderLookup.Provider)player.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.EFFICIENCY, stack);
            paid = efficiencyLevel == 0 ? InventoryHelper.removeFromInventoryWithRemainders(player, ITEM_COST) : (double)player.getRandom().nextFloat() > 2.0 / (double)(2 + efficiencyLevel) || InventoryHelper.removeFromInventoryWithRemainders(player, ITEM_COST);
        }
        return paid;
    }

    private static boolean canUse(Player player) {
        return player.isCreative() || InkPowered.hasAvailableInk(player, INK_COST) || player.getInventory().contains(ITEM_COST);
    }

    private void playDenySound(@NotNull Level world, @NotNull Player playerEntity) {
        world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), PastelSounds.USE_FAIL, SoundSource.PLAYERS, 1.0f, 0.8f + playerEntity.getRandom().nextFloat() * 0.4f);
    }

    @Override
    public List<InkColor> getUsedColors() {
        return List.of(INK_COST.color());
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getCount() == 1;
    }

    public int getEnchantmentValue() {
        return 10;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return super.supportsEnchantment(stack, enchantment) || enchantment.is(Enchantments.EFFICIENCY);
    }
}

