/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food.beverages;

import earth.terrarium.pastel.components.BeverageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.items.food.beverages.BeverageItem;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class RepriseItem
extends BeverageItem {
    public RepriseItem(Item.Properties settings) {
        super(settings);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            this.randomTeleport(serverWorld, user, RepriseItem.getTeleportRange(stack));
        }
        return super.finishUsingItem(stack, world, user);
    }

    public static long getTeleportRange(ItemStack itemStack) {
        int alcPercent = ((BeverageComponent)itemStack.getOrDefault(PastelDataComponentTypes.BEVERAGE, (Object)BeverageComponent.DEFAULT)).alcoholPercent();
        return (long)Math.ceil(Math.pow(2.0, alcPercent));
    }

    public void randomTeleport(ServerLevel world, LivingEntity user, long maxRange) {
        double d = user.getX();
        double e = user.getY();
        double f = user.getZ();
        for (int i = 0; i < 16; ++i) {
            double newX = user.getX() + (user.getRandom().nextDouble() - 0.5) * (double)maxRange;
            double newY = user.getY();
            double newZ = user.getZ() + (user.getRandom().nextDouble() - 0.5) * (double)maxRange;
            BlockPos destination = world.getWorldBorder().clampToBounds(newX, newY, newZ);
            Optional<BlockPos> safeDestination = Support.getNexReplaceableBlockPosUpDown((Level)world, destination, 20);
            if (!safeDestination.isPresent()) continue;
            destination = safeDestination.get();
            world.getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, new ChunkPos(destination), 1, (Object)user.getId());
            if (user.isSleeping()) {
                user.stopSleeping();
            }
            if (user.isPassenger()) {
                user.stopRiding();
            }
            user.teleportTo((double)destination.getX(), (double)destination.getY(), (double)destination.getZ());
            world.gameEvent((Holder)GameEvent.TELEPORT, user.position(), GameEvent.Context.of((Entity)user));
            SoundEvent soundEvent = user instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
            world.playSound(null, d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            user.playSound(soundEvent, 1.0f, 1.0f);
            break;
        }
        if (user instanceof Player) {
            ((Player)user).getCooldowns().addCooldown((Item)this, 20);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.reprise.tooltip.teleport", (Object[])new Object[]{RepriseItem.getTeleportRange(stack)}).withStyle(ChatFormatting.GRAY));
    }
}

