/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.food;

import earth.terrarium.pastel.items.trinkets.WhispyCircletItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EnchantedStarCandyItem
extends Item {
    public EnchantedStarCandyItem(Item.Properties settings) {
        super(settings);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        ItemStack itemStack = super.finishUsingItem(stack, world, user);
        user.heal(user.getMaxHealth());
        if (!world.isClientSide) {
            WhispyCircletItem.removeNegativeStatusEffects(user);
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.getFoodData().eat(1000, 1.0f);
        }
        return itemStack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.enchanted_star_candy.tooltip").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.pastel.enchanted_star_candy.tooltip2").withStyle(ChatFormatting.GRAY));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

