/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.energy;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.InkStorageItem;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.api.energy.storage.TotalCappedElementalMixingInkStorage;
import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.api.render.ExtendedItemBar;
import earth.terrarium.pastel.components.InkStorageComponent;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import earth.terrarium.pastel.registries.PastelDataComponentTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtistsPaletteItem
extends PastelTrinketItem
implements InkStorageItem<TotalCappedElementalMixingInkStorage>,
LoomPatternProvider,
ExtendedItemBar {
    private final long maxEnergyTotal;

    public ArtistsPaletteItem(Item.Properties settings, long maxEnergyTotal) {
        super(settings, PastelCommon.locate("unlocks/trinkets/artists_palette"));
        this.maxEnergyTotal = maxEnergyTotal;
    }

    @Override
    public InkStorageItem.Drainability getDrainability() {
        return InkStorageItem.Drainability.PLAYER_ONLY;
    }

    @Override
    public TotalCappedElementalMixingInkStorage getEnergyStorage(ItemStack itemStack) {
        InkStorageComponent storage = (InkStorageComponent)itemStack.get(PastelDataComponentTypes.INK_STORAGE);
        if (storage != null) {
            return new TotalCappedElementalMixingInkStorage(storage.maxEnergyTotal(), storage.storedEnergy());
        }
        return new TotalCappedElementalMixingInkStorage(this.maxEnergyTotal, Map.of());
    }

    @Override
    public ItemStack getDefaultInstance() {
        return super.getDefaultInstance();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.pastel.pigment_palette.tooltip.target").withStyle(ChatFormatting.GRAY));
        this.getEnergyStorage(stack).addTooltip(tooltip);
        this.addBannerPatternProviderTooltip(tooltip);
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.PALETTE;
    }

    @Override
    public int barCount(ItemStack stack) {
        return 1;
    }

    @Override
    public ExtendedItemBar.BarSignature getSignature(@Nullable Player player, @NotNull ItemStack stack, int index) {
        TotalCappedElementalMixingInkStorage storage = this.getEnergyStorage(stack);
        ArrayList<InkColor> colors = new ArrayList<InkColor>();
        if (player == null || storage.isEmpty()) {
            return ExtendedItemBar.PASS;
        }
        long time = player.level().getGameTime() % 864000L;
        for (InkColor inkColor : InkColors.elementals()) {
            if (storage.getEnergy(inkColor) <= 0L) continue;
            colors.add(inkColor);
        }
        int progress = Support.getSensiblePercent(storage.getCurrentTotal(), storage.getMaxTotal(), 14);
        if (colors.size() == 1) {
            InkColor color = (InkColor)colors.getFirst();
            return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, color.getColorInt() | 0xFF000000, 2, -16777216);
        }
        if (colors.isEmpty()) {
            return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, -16777216, 2, -16777216);
        }
        float delta = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false);
        InkColor curColor = (InkColor)colors.get((int)(time % (30L * (long)colors.size()) / 30L));
        InkColor nextColor = (InkColor)colors.get((int)((time % (30L * (long)colors.size()) / 30L + 1L) % (long)colors.size()));
        float blendFactor = ((float)time + delta) % 30.0f / 30.0f;
        int blendedColor = ColorHelper.interpolate(curColor.getTextColorVec(), nextColor.getTextColorVec(), blendFactor);
        return new ExtendedItemBar.BarSignature(1, 13, 14, progress, 1, blendedColor, 2, -16777216);
    }
}

