/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items.armor;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.ArmorWithHitEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class GemstoneArmorItem
extends ArmorItem
implements ArmorWithHitEffect {
    public GemstoneArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties settings) {
        super(material, type, settings);
    }

    @Override
    public void onHit(ItemStack itemStack, DamageSource source, LivingEntity targetEntity, float amount) {
        this.process(this.type, source, targetEntity);
        targetEntity.level().playSound(null, targetEntity.blockPosition(), SoundEvents.AMETHYST_BLOCK_HIT, SoundSource.PLAYERS, 1.0f, 1.0f);
        targetEntity.level().playSound(null, targetEntity.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
        itemStack.hurtAndBreak(2, targetEntity, this.type.getSlot());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipType) {
        super.appendHoverText(stack, context, tooltip, tooltipType);
        this.addTooltip(tooltip, this.type);
    }

    private void process(@NotNull ArmorItem.Type type, DamageSource source, LivingEntity targetEntity) {
        switch (type) {
            case HELMET: {
                if (!(source.getEntity() instanceof LivingEntity)) break;
                MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffects.WEAKNESS, 100, PastelCommon.CONFIG.GemstoneArmorWeaknessAmplifier);
                ((LivingEntity)source.getEntity()).addEffect(statusEffectInstance);
                statusEffectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, PastelCommon.CONFIG.GemstoneArmorSlownessAmplifier);
                ((LivingEntity)source.getEntity()).addEffect(statusEffectInstance);
                break;
            }
            case CHESTPLATE: {
                MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffects.ABSORPTION, 100, PastelCommon.CONFIG.GemstoneArmorAbsorptionAmplifier);
                targetEntity.addEffect(statusEffectInstance);
                statusEffectInstance = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 100, PastelCommon.CONFIG.GemstoneArmorResistanceAmplifier);
                targetEntity.addEffect(statusEffectInstance);
                break;
            }
            case LEGGINGS: {
                MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffects.REGENERATION, 100, PastelCommon.CONFIG.GemstoneArmorRegenerationAmplifier);
                targetEntity.addEffect(statusEffectInstance);
                break;
            }
            case BOOTS: {
                MobEffectInstance statusEffectInstance = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, PastelCommon.CONFIG.GemstoneArmorSpeedAmplifier);
                targetEntity.addEffect(statusEffectInstance);
                statusEffectInstance = new MobEffectInstance(MobEffects.INVISIBILITY, 100, 0);
                targetEntity.addEffect(statusEffectInstance);
            }
        }
    }

    public void addTooltip(List<Component> tooltip, @NotNull ArmorItem.Type equipmentSlot) {
        switch (equipmentSlot) {
            case HELMET: {
                tooltip.add((Component)Component.translatable((String)"item.pastel.fetchling_helmet.tooltip").withStyle(ChatFormatting.GRAY));
                break;
            }
            case CHESTPLATE: {
                tooltip.add((Component)Component.translatable((String)"item.pastel.ferocious_chestplate.tooltip").withStyle(ChatFormatting.GRAY));
                break;
            }
            case LEGGINGS: {
                tooltip.add((Component)Component.translatable((String)"item.pastel.sylph_leggings.tooltip").withStyle(ChatFormatting.GRAY));
                break;
            }
            case BOOTS: {
                tooltip.add((Component)Component.translatable((String)"item.pastel.oread_boots.tooltip").withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

