/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import com.cmdpro.databank.advancement.criteria.HasAdvancementCriteria;
import com.klikli_dev.modonomicon.client.gui.BookGuiManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.item.LoomPatternProvider;
import earth.terrarium.pastel.registries.PastelBannerPatterns;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;

public class GuidebookItem
extends Item
implements LoomPatternProvider {
    public static final ResourceLocation GUIDEBOOK_ID = PastelCommon.locate("guidebook");
    public static final BookAddress GUIDEBOOK_ADDRESS = BookAddress.defaultFor((ResourceLocation)GUIDEBOOK_ID);
    public static final ResourceLocation CUISINE_CATEGORY_ID = PastelCommon.locate("cuisine");
    public static final ResourceLocation DIMENSION_CATEGORY_ID = PastelCommon.locate("dimension");
    private static final Set<UUID> alreadyReprocessedPlayers = new HashSet<UUID>();

    public static BookAddress addressOf(ResourceLocation category, ResourceLocation entryId) {
        return BookAddress.of((ResourceLocation)GUIDEBOOK_ID, (ResourceLocation)category, (ResourceLocation)entryId, (int)0);
    }

    public GuidebookItem(Item.Properties settings) {
        super(settings);
    }

    public static void reprocessAdvancementUnlocks(ServerPlayer serverPlayerEntity) {
        if (serverPlayerEntity.getServer() == null || PastelCommon.getSidedServer() == null) {
            return;
        }
        UUID uuid = serverPlayerEntity.getUUID();
        if (alreadyReprocessedPlayers.contains(uuid)) {
            return;
        }
        alreadyReprocessedPlayers.add(uuid);
        PlayerAdvancements tracker = serverPlayerEntity.getAdvancements();
        for (AdvancementHolder advancement : serverPlayerEntity.getServer().getAdvancements().getAllAdvancements()) {
            AdvancementProgress hasAdvancement = tracker.getOrStartProgress(advancement);
            if (hasAdvancement.isDone()) continue;
            for (Map.Entry criterionEntry : advancement.value().criteria().entrySet()) {
                AdvancementProgress hasAdvancementCriterionAdvancement;
                CriterionTriggerInstance conditions = ((Criterion)criterionEntry.getValue()).triggerInstance();
                if (!(conditions instanceof HasAdvancementCriteria.HasAdvancementCriteriaInstance)) continue;
                HasAdvancementCriteria.HasAdvancementCriteriaInstance hasAdvancementConditions = (HasAdvancementCriteria.HasAdvancementCriteriaInstance)conditions;
                AdvancementHolder advancementCriterionAdvancement = PastelCommon.getSidedServer().getAdvancements().get(hasAdvancementConditions.advancement());
                if (advancementCriterionAdvancement == null || !(hasAdvancementCriterionAdvancement = tracker.getOrStartProgress(advancementCriterionAdvancement)).isDone()) continue;
                tracker.award(advancement, (String)criterionEntry.getKey());
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide()) {
            this.openGuidebook();
        } else if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)user;
            GuidebookItem.reprocessAdvancementUnlocks(serverPlayerEntity);
        }
        user.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)user.getItemInHand(hand), (boolean)world.isClientSide);
    }

    public void openGuidebook() {
        BookGuiManager.get().openBook(GUIDEBOOK_ADDRESS);
    }

    public void openGuidebook(BookAddress address) {
        BookGuiManager.get().openBook(address);
    }

    @Override
    public ResourceKey<BannerPattern> getPattern() {
        return PastelBannerPatterns.GUIDEBOOK;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        this.addBannerPatternProviderTooltip(tooltip);
    }
}

