/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.items;

import earth.terrarium.pastel.registries.PastelBlockTags;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;

public class DecayPlacerItem
extends ItemNameBlockItem {
    protected final List<Component> tooltips;

    public DecayPlacerItem(Block block, Item.Properties settings, List<Component> tooltips) {
        super(block, settings);
        this.tooltips = tooltips;
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPlaceContext itemPlacementContext;
        Level world = context.getLevel();
        InteractionResult actionResult = super.useOn(context);
        if (actionResult.consumesAction() && (itemPlacementContext = this.updatePlacementContext(new BlockPlaceContext(context))) != null) {
            BlockPos blockPos = itemPlacementContext.getClickedPos();
            BlockState placedBlockState = context.getLevel().getBlockState(blockPos);
            if (placedBlockState.is(PastelBlockTags.DECAY)) {
                context.getLevel().scheduleTick(blockPos, placedBlockState.getBlock(), 40 + world.random.nextInt(200), TickPriority.EXTREMELY_LOW);
            }
        }
        if (!world.isClientSide && actionResult.consumesAction() && context.getPlayer() != null && !context.getPlayer().isCreative()) {
            context.getPlayer().getInventory().placeItemBackInInventory(Items.GLASS_BOTTLE.getDefaultInstance());
        }
        return actionResult;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.addAll(this.tooltips);
    }
}

