/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories.widgets;

import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StackedInkMeterWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean hovered;
    protected boolean focused;
    protected final Screen screen;
    protected final InkStorageBlockEntity<?> blockEntity;

    public StackedInkMeterWidget(int x, int y, int width, int height, Screen screen, InkStorageBlockEntity<?> blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput builder) {
    }

    public void drawMouseoverTooltip(GuiGraphics drawContext, int x, int y) {
        Minecraft client = Minecraft.getInstance();
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        String readableCurrentTotalString = Support.getShortenedNumberString(currentTotal);
        String percent = Support.getSensiblePercentString(inkStorage.getCurrentTotal(), inkStorage.getMaxTotal());
        drawContext.renderTooltip(client.font, List.of(Component.translatable((String)"pastel.tooltip.ink_powered.percent_filled", (Object[])new Object[]{readableCurrentTotalString, percent})), Optional.empty(), x, y);
    }

    public void draw(GuiGraphics drawContext) {
        Object inkStorage = this.blockEntity.getEnergyStorage();
        long currentTotal = inkStorage.getCurrentTotal();
        if (currentTotal > 0L) {
            long maxTotal = inkStorage.getMaxTotal();
            int currentHeight = this.y + this.height;
            for (InkColor color : InkColors.all()) {
                long amount = inkStorage.getEnergy(color);
                if (amount <= 0L) continue;
                int height = Math.round((float)amount / (float)maxTotal * (float)this.height);
                if (height > 0) {
                    RenderHelper.fillQuad(drawContext.pose(), this.x, currentHeight - height, height, this.width, color.getColorVec());
                }
                currentHeight -= height;
            }
        }
    }
}

