/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories.widgets;

import earth.terrarium.pastel.api.energy.InkStorage;
import earth.terrarium.pastel.api.energy.InkStorageBlockEntity;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.helpers.render.RenderHelper;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InkGaugeWidget
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final int x;
    public final int y;
    public final int width;
    public final int height;
    protected boolean focused;
    protected boolean hovered;
    protected final Screen screen;
    protected final InkStorageBlockEntity<?> blockEntity;

    public InkGaugeWidget(int x, int y, int width, int height, Screen screen, InkStorageBlockEntity<?> blockEntity) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.screen = screen;
        this.blockEntity = blockEntity;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return this.hovered ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput builder) {
    }

    public void drawMouseoverTooltip(GuiGraphics drawContext, int x, int y) {
        Minecraft client = Minecraft.getInstance();
        ArrayList<Component> tooltip = new ArrayList<Component>();
        for (InkColor color : InkColors.all()) {
            long amount = this.blockEntity.getEnergyStorage().getEnergy(color);
            if (amount <= 0L) continue;
            InkStorage.addInkStoreBulletTooltip(tooltip, color, amount);
        }
        if (tooltip.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"pastel.tooltip.ink_powered.empty"));
        } else {
            tooltip.add(0, (Component)Component.translatable((String)"pastel.tooltip.ink_powered.stored"));
        }
        drawContext.renderTooltip(client.font, tooltip, Optional.empty(), x, y);
    }

    public void draw(GuiGraphics drawContext) {
        long totalInk = this.blockEntity.getEnergyStorage().getCurrentTotal();
        if (totalInk > 0L) {
            int centerX = this.x + this.width / 2;
            int centerY = this.y + this.width / 2;
            int radius = 22;
            double startRad = -1.5707963267948966;
            for (InkColor color : InkColors.all()) {
                double curr;
                long currentInk = this.blockEntity.getEnergyStorage().getEnergy(color);
                if (currentInk <= 0L) continue;
                for (double thisPart = (double)currentInk / (double)totalInk; thisPart > 0.0; thisPart -= curr) {
                    curr = Math.min(0.2, thisPart);
                    double endRad = startRad + curr * 2.0 * Math.PI;
                    int p2x = (int)((double)radius * Math.cos(startRad));
                    int p2y = (int)((double)radius * Math.sin(startRad));
                    int p3x = (int)((double)radius * Math.cos(endRad));
                    int p3y = (int)((double)radius * Math.sin(endRad));
                    RenderHelper.fillTriangle(drawContext.pose(), centerX, centerY, centerX + p3x, centerY + p3y, centerX + p2x, centerY + p2y, color.getColorVec());
                    double middleRad = startRad + curr * Math.PI;
                    int pmx = (int)((double)radius * Math.cos(middleRad));
                    int pmy = (int)((double)radius * Math.sin(middleRad));
                    RenderHelper.fillTriangle(drawContext.pose(), centerX + p3x, centerY + p3y, centerX + pmx, centerY + pmy, centerX + p2x, centerY + p2y, color.getColorVec());
                    startRad = endRad;
                }
            }
        }
    }
}

