/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.pedestal.PedestalBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.DisabledSlot;
import earth.terrarium.pastel.inventories.slots.PedestalPreviewSlot;
import earth.terrarium.pastel.inventories.slots.StackFilterSlot;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelBlockEntities;
import earth.terrarium.pastel.registries.PastelItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class PedestalScreenHandler
extends RecipeBookMenu<RecipeInput, Recipe<RecipeInput>> {
    protected final Level world;
    private final PedestalBlockEntity pedestal;
    private final ContainerData data;
    private final RecipeBookType category;
    private final PedestalTier pedestalRecipeTier;

    public PedestalScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (ScreenOpeningData)ScreenOpeningData.STREAM_CODEC.decode((Object)buf));
    }

    public PedestalScreenHandler(int syncId, Inventory playerInventory, ScreenOpeningData data) {
        this(syncId, playerInventory, (PedestalBlockEntity)playerInventory.player.level().getBlockEntity(data.pos, (BlockEntityType)PastelBlockEntities.PEDESTAL.get()).orElseThrow(), (ContainerData)new SimpleContainerData(2), data.pedestalRecipeTier);
    }

    public PedestalScreenHandler(int syncId, Inventory pInv, PedestalBlockEntity blockEntity, ContainerData data, PedestalTier tier) {
        this(PastelScreenHandlerTypes.PEDESTAL, RecipeBookType.CRAFTING, syncId, pInv, blockEntity, data, tier);
    }

    protected PedestalScreenHandler(MenuType<?> type, RecipeBookType recipeBookCategory, int i, Inventory pInv, PedestalBlockEntity pedestal, ContainerData data, PedestalTier tier) {
        super(type, i);
        int l;
        this.category = recipeBookCategory;
        this.data = data;
        this.world = pInv.player.level();
        this.pedestal = pedestal;
        this.pedestalRecipeTier = tier;
        PedestalScreenHandler.checkContainerSize((Container)pedestal, (int)16);
        PedestalScreenHandler.checkContainerDataCount((ContainerData)data, (int)2);
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 3; ++n) {
                this.addSlot(new Slot((Container)pedestal, n + m * 3, 30 + n * 18, 19 + m * 18));
            }
        }
        switch (this.getTier()) {
            case BASIC: 
            case SIMPLE: {
                this.addSlot(new StackFilterSlot((Container)pedestal, 9, 62, 77, (Item)PastelItems.TOPAZ_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 10, 80, 77, (Item)PastelItems.AMETHYST_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 11, 98, 77, (Item)PastelItems.CITRINE_POWDER.get()));
                this.addSlot(new DisabledSlot((Container)pedestal, 12, -2000, 77));
                this.addSlot(new DisabledSlot((Container)pedestal, 13, -2000, 77));
                break;
            }
            case ADVANCED: {
                this.addSlot(new StackFilterSlot((Container)pedestal, 9, 53, 77, (Item)PastelItems.TOPAZ_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 10, 71, 77, (Item)PastelItems.AMETHYST_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 11, 89, 77, (Item)PastelItems.CITRINE_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 12, 107, 77, (Item)PastelItems.ONYX_POWDER.get()));
                this.addSlot(new DisabledSlot((Container)pedestal, 13, -2000, 77));
                break;
            }
            case COMPLEX: {
                this.addSlot(new StackFilterSlot((Container)pedestal, 9, 44, 77, (Item)PastelItems.TOPAZ_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 10, 62, 77, (Item)PastelItems.AMETHYST_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 11, 80, 77, (Item)PastelItems.CITRINE_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 12, 98, 77, (Item)PastelItems.ONYX_POWDER.get()));
                this.addSlot(new StackFilterSlot((Container)pedestal, 13, 116, 77, (Item)PastelItems.MOONSTONE_POWDER.get()));
            }
        }
        this.addSlot(new StackFilterSlot((Container)pedestal, 14, 93, 19, (Item)PastelItems.CRAFTING_TABLET.get()));
        this.addSlot(new PedestalPreviewSlot(pedestal, 15, 127, 37));
        for (l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)pInv, k + l * 9 + 9, 8 + k * 18, 112 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)pInv, l, 8 + l * 18, 170));
        }
        this.addDataSlots(data);
    }

    public void fillCraftSlotsStackedContents(StackedContents recipeMatcher) {
    }

    public void clearCraftingContent() {
        for (int i = 0; i < 9; ++i) {
            this.getSlot(i).setByPlayer(ItemStack.EMPTY);
        }
    }

    public boolean recipeMatches(RecipeHolder<Recipe<RecipeInput>> recipe) {
        return this.pedestal != null && recipe.value().matches((RecipeInput)this.pedestal.getInput(), this.world);
    }

    public int getResultSlotIndex() {
        return 16;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 9;
    }

    public boolean stillValid(Player player) {
        return this.pedestal.stillValid(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCraftingProgress() {
        float time = this.getCraftingTime();
        if (time < 0.0f) {
            return 0;
        }
        return Math.round(time / (float)this.getCraftingTimeTotal() * 24.0f);
    }

    public boolean isCrafting() {
        return this.getCraftingTime() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public RecipeBookType getRecipeBookType() {
        return this.category;
    }

    public boolean shouldMoveToInventory(int index) {
        return index != 1;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack clickedStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack clickedStack = slot.getItem();
            clickedStackCopy = clickedStack.copy();
            if (index < 15 ? !this.moveItemStackTo(clickedStack, 16, 51, false) : (clickedStackCopy.is((Item)PastelItems.TOPAZ_POWDER.get()) ? !this.moveItemStackTo(clickedStack, 9, 10, false) : (clickedStackCopy.is((Item)PastelItems.AMETHYST_POWDER.get()) ? !this.moveItemStackTo(clickedStack, 10, 11, false) : (clickedStackCopy.is((Item)PastelItems.CITRINE_POWDER.get()) ? !this.moveItemStackTo(clickedStack, 11, 12, false) : (clickedStackCopy.is((Item)PastelItems.ONYX_POWDER.get()) ? !this.moveItemStackTo(clickedStack, 12, 13, false) : (clickedStackCopy.is((Item)PastelItems.MOONSTONE_POWDER.get()) ? !this.moveItemStackTo(clickedStack, 13, 14, false) : clickedStackCopy.is((Item)PastelItems.CRAFTING_TABLET.get()) && !this.moveItemStackTo(clickedStack, 14, 15, false))))))) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(clickedStack, 0, 9, false)) {
                this.pedestal.setChanged();
                return ItemStack.EMPTY;
            }
            if (clickedStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (clickedStack.getCount() == clickedStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, clickedStack);
        }
        return clickedStackCopy;
    }

    public int getCraftingTime() {
        return this.data.get(0);
    }

    public int getCraftingTimeTotal() {
        return this.data.get(1);
    }

    public PedestalTier getTier() {
        return this.pedestalRecipeTier;
    }

    public PedestalBlockEntity getBlockEntity() {
        return this.pedestal;
    }

    public BlockPos getBlockPos() {
        return this.pedestal.getBlockPos();
    }

    public void removed(Player player) {
        super.removed(player);
    }

    public record ScreenOpeningData(BlockPos pos, PedestalTier pedestalRecipeTier) {
        public static final StreamCodec<ByteBuf, ScreenOpeningData> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ScreenOpeningData::pos, PedestalTier.STREAM_CODEC, ScreenOpeningData::pedestalRecipeTier, ScreenOpeningData::new);
    }
}

