/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.PedestalScreenHandler;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PedestalScreen
extends AbstractContainerScreen<PedestalScreenHandler> {
    public static final ResourceLocation BACKGROUND1 = PastelCommon.locate("textures/gui/container/pedestal1.png");
    public static final ResourceLocation BACKGROUND2 = PastelCommon.locate("textures/gui/container/pedestal2.png");
    public static final ResourceLocation BACKGROUND3 = PastelCommon.locate("textures/gui/container/pedestal3.png");
    public static final ResourceLocation BACKGROUND4 = PastelCommon.locate("textures/gui/container/pedestal4.png");
    private final ResourceLocation backgroundTexture;

    public PedestalScreen(PedestalScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.imageHeight = 194;
        this.backgroundTexture = PedestalScreen.getBackgroundTextureForTier(((PedestalScreenHandler)this.menu).getTier());
    }

    @Contract(pure=true)
    public static ResourceLocation getBackgroundTextureForTier(@NotNull PedestalTier recipeTier) {
        switch (recipeTier) {
            case COMPLEX: {
                return BACKGROUND4;
            }
            case ADVANCED: {
                return BACKGROUND3;
            }
            case SIMPLE: {
                return BACKGROUND2;
            }
        }
        return BACKGROUND1;
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 7;
        Component title = this.title;
        int inventoryX = 8;
        int intInventoryY = 100;
        Font tr = this.font;
        drawContext.drawString(tr, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(tr, this.playerInventoryTitle, inventoryX, intInventoryY, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.backgroundTexture, x, y, 0, 0, this.imageWidth, this.imageHeight);
        boolean isCrafting = ((PedestalScreenHandler)this.menu).isCrafting();
        if (isCrafting) {
            int progressWidth = ((PedestalScreenHandler)this.menu).getCraftingProgress();
            drawContext.blit(this.backgroundTexture, x + 88, y + 37, 176, 0, progressWidth + 1, 16);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }
}

