/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.inventories.GenericPastelContainerScreenHandler;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class PastelGenericContainerScreen
extends AbstractContainerScreen<GenericPastelContainerScreenHandler> {
    private static final ResourceLocation TIER_1_TEXTURE_6x9 = PastelCommon.locate("textures/gui/container/generic_54_tier_1.png");
    private static final ResourceLocation TIER_2_TEXTURE_6x9 = PastelCommon.locate("textures/gui/container/generic_54_tier_2.png");
    private static final ResourceLocation TIER_3_TEXTURE_6x9 = PastelCommon.locate("textures/gui/container/generic_54_tier_3.png");
    private final int rows;
    private final ResourceLocation backgroundTexture;

    public PastelGenericContainerScreen(GenericPastelContainerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.rows = handler.getRowCount();
        this.backgroundTexture = this.getBackground(this.rows, handler.getTier());
        this.imageHeight = 114 + this.rows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 7;
        Component title = this.title;
        int inventoryX = 8;
        Font tr = this.font;
        drawContext.drawString(tr, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(tr, this.playerInventoryTitle, inventoryX, this.inventoryLabelY, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.backgroundTexture, i, j, 0, 0, this.imageWidth, this.rows * 18 + 17);
        drawContext.blit(this.backgroundTexture, i, j + this.rows * 18 + 17, 0, 126, this.imageWidth, 96);
    }

    @Contract(pure=true)
    private ResourceLocation getBackground(int rows, @NotNull ScreenBackgroundVariant tier) {
        switch (tier) {
            case EARLYGAME: {
                return TIER_1_TEXTURE_6x9;
            }
            case MIDGAME: {
                return TIER_2_TEXTURE_6x9;
            }
        }
        return TIER_3_TEXTURE_6x9;
    }
}

