/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.redstone.BlockPlacerBlockEntity;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Pastel3x3ContainerScreenHandler
extends AbstractContainerMenu {
    private final ScreenBackgroundVariant tier;
    private final Container inventory;

    public Pastel3x3ContainerScreenHandler(int syncId, Inventory playerInventory, ScreenBackgroundVariant screenBackgroundVariant) {
        this(PastelScreenHandlerTypes.GENERIC_TIER1_3X3, syncId, playerInventory, (Container)new SimpleContainer(9), screenBackgroundVariant);
    }

    public Pastel3x3ContainerScreenHandler(MenuType<Pastel3x3ContainerScreenHandler> screenHandlerType, int syncId, Inventory playerInventory, Container inventory, ScreenBackgroundVariant screenBackgroundVariant) {
        super(screenHandlerType, syncId);
        int l;
        int m;
        Pastel3x3ContainerScreenHandler.checkContainerSize((Container)inventory, (int)9);
        this.tier = screenBackgroundVariant;
        this.inventory = inventory;
        inventory.startOpen(playerInventory.player);
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 3; ++l) {
                this.addSlot(new Slot(inventory, l + m * 3, 62 + l * 18, 17 + m * 18));
            }
        }
        for (m = 0; m < 3; ++m) {
            for (l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)playerInventory, m, 8 + m * 18, 142));
        }
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Pastel3x3ContainerScreenHandler createTier1(int syncId, Inventory playerInventory) {
        return new Pastel3x3ContainerScreenHandler(syncId, playerInventory, ScreenBackgroundVariant.EARLYGAME);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static AbstractContainerMenu createTier1(int syncId, Inventory playerInventory, BlockPlacerBlockEntity blockEntity) {
        return new Pastel3x3ContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_3X3, syncId, playerInventory, (Container)blockEntity, ScreenBackgroundVariant.EARLYGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Pastel3x3ContainerScreenHandler createTier2(int syncId, Inventory playerInventory) {
        return new Pastel3x3ContainerScreenHandler(syncId, playerInventory, ScreenBackgroundVariant.MIDGAME);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static AbstractContainerMenu createTier2(int syncId, Inventory playerInventory, BlockPlacerBlockEntity blockEntity) {
        return new Pastel3x3ContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_3X3, syncId, playerInventory, (Container)blockEntity, ScreenBackgroundVariant.MIDGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static Pastel3x3ContainerScreenHandler createTier3(int syncId, Inventory playerInventory) {
        return new Pastel3x3ContainerScreenHandler(syncId, playerInventory, ScreenBackgroundVariant.LATEGAME);
    }

    @Contract(value="_, _, _ -> new")
    @NotNull
    public static AbstractContainerMenu createTier3(int syncId, Inventory playerInventory, BlockPlacerBlockEntity blockEntity) {
        return new Pastel3x3ContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_3X3, syncId, playerInventory, (Container)blockEntity, ScreenBackgroundVariant.LATEGAME);
    }

    public boolean stillValid(Player player) {
        return this.inventory.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < 9 ? !this.moveItemStackTo(itemStack2, 9, 45, true) : !this.moveItemStackTo(itemStack2, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemStack2.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemStack2);
        }
        return itemStack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.inventory.stopOpen(player);
    }

    public ScreenBackgroundVariant getTier() {
        return this.tier;
    }
}

