/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import com.mojang.blaze3d.systems.RenderSystem;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.particle_spawner.ParticleSpawnerBlockEntity;
import earth.terrarium.pastel.blocks.particle_spawner.ParticleSpawnerConfiguration;
import earth.terrarium.pastel.data_loaders.ParticleSpawnerParticlesDataLoader;
import earth.terrarium.pastel.inventories.ParticleSpawnerScreenHandler;
import earth.terrarium.pastel.mixin.client.accessors.ParticleManagerAccessor;
import earth.terrarium.pastel.networking.c2s_payloads.ParticleSpawnerConfigurationC2SPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ParticleSpawnerScreen
extends AbstractContainerScreen<ParticleSpawnerScreenHandler> {
    protected static final ResourceLocation GUI_TEXTURE = PastelCommon.locate("textures/gui/container/particle_spawner.png");
    protected static final int PARTICLES_PER_PAGE = 6;
    protected static final int TEXT_COLOR = 0x222222;
    protected TextureAtlas spriteAtlasTexture;
    protected boolean glowing = false;
    protected boolean collisionsEnabled = false;
    protected int activeParticlePage = 0;
    protected int particleSelectionIndex = 0;
    protected boolean selectedParticleSupportsColoring = false;
    private final List<AbstractWidget> selectableWidgets = new ArrayList<AbstractWidget>();
    private EditBox cyanField;
    private EditBox magentaField;
    private EditBox yellowField;
    private EditBox amountField;
    private EditBox positionXField;
    private EditBox positionYField;
    private EditBox positionZField;
    private EditBox positionXVarianceField;
    private EditBox positionYVarianceField;
    private EditBox positionZVarianceField;
    private EditBox velocityXField;
    private EditBox velocityYField;
    private EditBox velocityZField;
    private EditBox velocityXVarianceField;
    private EditBox velocityYVarianceField;
    private EditBox velocityZVarianceField;
    private EditBox scale;
    private EditBox scaleVariance;
    private EditBox duration;
    private EditBox durationVariance;
    private EditBox gravity;
    private Button glowingButton;
    private Button collisionsButton;
    private Button backButton;
    private Button forwardButton;
    private List<Button> particleButtons;
    private List<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry> displayedParticleEntries = new ArrayList<ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry>();

    public ParticleSpawnerScreen(ParticleSpawnerScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.titleLabelX = 48;
        this.titleLabelY = 7;
        this.imageHeight = 243;
    }

    protected void init() {
        super.init();
        this.spriteAtlasTexture = ((ParticleManagerAccessor)this.minecraft.particleEngine).getTextureAtlas();
        this.displayedParticleEntries = ParticleSpawnerParticlesDataLoader.getAllUnlocked((Player)this.minecraft.player);
        this.selectableWidgets.clear();
        this.setupInputFields(((ParticleSpawnerScreenHandler)this.menu).getBlockEntity());
        this.setInitialFocus((GuiEventListener)this.amountField);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        GuiEventListener focusedElement;
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        if ((focusedElement = this.getFocused()) instanceof EditBox) {
            EditBox focusedTextFieldWidget = (EditBox)focusedElement;
            if (keyCode == 258) {
                int currentIndex = this.selectableWidgets.indexOf(focusedElement);
                focusedTextFieldWidget.setFocused(false);
                if (modifiers == 1) {
                    this.setFocused((GuiEventListener)this.selectableWidgets.get((this.selectableWidgets.size() + currentIndex - 1) % this.selectableWidgets.size()));
                } else {
                    this.setFocused((GuiEventListener)this.selectableWidgets.get((currentIndex + 1) % this.selectableWidgets.size()));
                }
            }
            return focusedElement.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.renderForeground(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }

    public void renderForeground(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        for (AbstractWidget widget : this.selectableWidgets) {
            if (!(widget instanceof EditBox)) continue;
            widget.render(drawContext, mouseX, mouseY, delta);
        }
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        Font tr = this.font;
        drawContext.drawString(tr, this.title, this.titleLabelX, this.titleLabelY, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"C").withStyle(ChatFormatting.AQUA), 7, 54, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"M").withStyle(ChatFormatting.LIGHT_PURPLE), 47, 54, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"Y").withStyle(ChatFormatting.GOLD), 90, 54, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"Glow"), 130, 54, 0x222222, false);
        int offset = 23;
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.particle_count"), 10, 53 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"x"), 66, 64 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"y"), 99, 64 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.literal((String)"z"), 134, 64 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.offset"), 10, 78 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.variance"), 21, 97 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.velocity"), 10, 117 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.variance"), 21, 137 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.scale"), 10, 161 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.variance"), 91, 161 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.duration"), 10, 181 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.variance"), 91, 181 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.gravity"), 10, 201 + offset, 0x222222, false);
        drawContext.drawString(tr, (Component)Component.translatable((String)"block.pastel.particle_spawner.collisions"), 90, 201 + offset, 0x222222, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int spriteIndex;
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        drawContext.blit(GUI_TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (!this.selectedParticleSupportsColoring) {
            drawContext.blit(GUI_TEXTURE, x + 15, y + 50, 214, 0, 31, 16);
            drawContext.blit(GUI_TEXTURE, x + 56, y + 50, 214, 0, 31, 16);
            drawContext.blit(GUI_TEXTURE, x + 97, y + 50, 214, 0, 31, 16);
        }
        if (this.collisionsEnabled) {
            drawContext.blit(GUI_TEXTURE, x + 146, y + 220, 176, 0, 16, 16);
        }
        if (this.glowing) {
            drawContext.blit(GUI_TEXTURE, x + 153, y + 50, 176, 0, 16, 16);
        }
        if (this.particleSelectionIndex / 6 == this.activeParticlePage) {
            drawContext.blit(GUI_TEXTURE, x + 27 + 20 * (this.particleSelectionIndex % 6), y + 19, 192, 0, 22, 22);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.spriteAtlasTexture.location());
        int firstDisplayedEntryId = 6 * this.activeParticlePage;
        for (int j = 0; j < 6 && (spriteIndex = firstDisplayedEntryId + j) < this.displayedParticleEntries.size(); ++j) {
            TextureAtlasSprite particleSprite = this.spriteAtlasTexture.getSprite(this.displayedParticleEntries.get(spriteIndex).textureIdentifier());
            SpriteContents contents = particleSprite.contents();
            drawContext.blit(x + 38 + j * 20 - contents.width() / 2, y + 31 - contents.height() / 2, 0, contents.width(), contents.height(), particleSprite);
        }
    }

    protected void setupInputFields(ParticleSpawnerBlockEntity blockEntity) {
        int startX = (this.width - this.imageWidth) / 2 + 3;
        int startY = (this.height - this.imageHeight) / 2 + 3;
        ParticleSpawnerConfiguration configuration = blockEntity.getConfiguration();
        this.cyanField = this.addTextFieldWidget(startX + 16, startY + 51, (Component)Component.literal((String)"Cyan"), String.valueOf(configuration.cmyColor().getX()), this::isPositiveDecimalNumber100);
        this.magentaField = this.addTextFieldWidget(startX + 57, startY + 51, (Component)Component.literal((String)"Magenta"), String.valueOf(configuration.cmyColor().getY()), this::isPositiveDecimalNumber100);
        this.yellowField = this.addTextFieldWidget(startX + 97, startY + 51, (Component)Component.literal((String)"Yellow"), String.valueOf(configuration.cmyColor().getZ()), this::isPositiveDecimalNumber100);
        this.glowingButton = Button.builder((Component)Component.translatable((String)"gui.pastel.button.glowing"), this::glowingButtonPressed).size(16, 16).pos(startX + 153, startY + 50).build();
        this.addWidget((GuiEventListener)this.glowingButton);
        this.glowing = configuration.glowing();
        int offset = 23;
        this.amountField = this.addTextFieldWidget(startX + 110, startY + 50 + offset, (Component)Component.literal((String)"Particles per Second"), String.valueOf(configuration.particlesPerSecond()), this::isPositiveDecimalNumberUnderThousand);
        this.positionXField = this.addTextFieldWidget(startX + 61, startY + 74 + offset, (Component)Component.literal((String)"X Position"), String.valueOf(configuration.sourcePosition().x), this::isAbsoluteDecimalNumberThousand);
        this.positionYField = this.addTextFieldWidget(startX + 96, startY + 74 + offset, (Component)Component.literal((String)"Y Position"), String.valueOf(configuration.sourcePosition().y), this::isAbsoluteDecimalNumberThousand);
        this.positionZField = this.addTextFieldWidget(startX + 131, startY + 74 + offset, (Component)Component.literal((String)"Z Position"), String.valueOf(configuration.sourcePosition().z), this::isAbsoluteDecimalNumberThousand);
        this.positionXVarianceField = this.addTextFieldWidget(startX + 69, startY + 94 + offset, (Component)Component.literal((String)"X Position Variance"), String.valueOf(configuration.sourcePositionVariance().x), this::isAbsoluteDecimalNumberThousand);
        this.positionYVarianceField = this.addTextFieldWidget(startX + 104, startY + 94 + offset, (Component)Component.literal((String)"Y Position Variance"), String.valueOf(configuration.sourcePositionVariance().y), this::isAbsoluteDecimalNumberThousand);
        this.positionZVarianceField = this.addTextFieldWidget(startX + 140, startY + 94 + offset, (Component)Component.literal((String)"Z Position Variance"), String.valueOf(configuration.sourcePositionVariance().z), this::isAbsoluteDecimalNumberThousand);
        this.velocityXField = this.addTextFieldWidget(startX + 61, startY + 114 + offset, (Component)Component.literal((String)"X Velocity"), String.valueOf(configuration.velocity().x), this::isAbsoluteDecimalNumberThousand);
        this.velocityYField = this.addTextFieldWidget(startX + 96, startY + 114 + offset, (Component)Component.literal((String)"Y Velocity"), String.valueOf(configuration.velocity().y), this::isAbsoluteDecimalNumberThousand);
        this.velocityZField = this.addTextFieldWidget(startX + 131, startY + 114 + offset, (Component)Component.literal((String)"Z Velocity"), String.valueOf(configuration.velocity().z), this::isAbsoluteDecimalNumberThousand);
        this.velocityXVarianceField = this.addTextFieldWidget(startX + 69, startY + 134 + offset, (Component)Component.literal((String)"X Velocity Variance"), String.valueOf(configuration.velocityVariance().x), this::isAbsoluteDecimalNumberThousand);
        this.velocityYVarianceField = this.addTextFieldWidget(startX + 104, startY + 134 + offset, (Component)Component.literal((String)"Y Velocity Variance"), String.valueOf(configuration.velocityVariance().y), this::isAbsoluteDecimalNumberThousand);
        this.velocityZVarianceField = this.addTextFieldWidget(startX + 140, startY + 134 + offset, (Component)Component.literal((String)"Z Velocity Variance"), String.valueOf(configuration.velocityVariance().z), this::isAbsoluteDecimalNumberThousand);
        this.scale = this.addTextFieldWidget(startX + 55, startY + 158 + offset, (Component)Component.literal((String)"Scale"), String.valueOf(configuration.scale()), this::isPositiveDecimalNumberUnderTen);
        this.scaleVariance = this.addTextFieldWidget(startX + 139, startY + 158 + offset, (Component)Component.literal((String)"Scale Variance"), String.valueOf(configuration.scaleVariance()), this::isPositiveDecimalNumberUnderTen);
        this.duration = this.addTextFieldWidget(startX + 55, startY + 178 + offset, (Component)Component.literal((String)"Duration"), String.valueOf(configuration.lifetimeTicks()), this::isPositiveWholeNumberUnderThousand);
        this.durationVariance = this.addTextFieldWidget(startX + 139, startY + 178 + offset, (Component)Component.literal((String)"Duration Variance"), String.valueOf(configuration.lifetimeVariance()), this::isPositiveWholeNumberUnderThousand);
        this.gravity = this.addTextFieldWidget(startX + 55, startY + 198 + offset, (Component)Component.literal((String)"Gravity"), String.valueOf(configuration.gravity()), this::isBetweenZeroAndOne);
        this.collisionsButton = Button.builder((Component)Component.translatable((String)"gui.pastel.button.collisions"), this::collisionButtonPressed).pos(startX + 142, startY + 194 + offset).size(16, 16).build();
        this.collisionsEnabled = configuration.collisions();
        this.addWidget((GuiEventListener)this.collisionsButton);
        this.selectableWidgets.add((AbstractWidget)this.cyanField);
        this.selectableWidgets.add((AbstractWidget)this.magentaField);
        this.selectableWidgets.add((AbstractWidget)this.yellowField);
        this.selectableWidgets.add((AbstractWidget)this.glowingButton);
        this.selectableWidgets.add((AbstractWidget)this.amountField);
        this.selectableWidgets.add((AbstractWidget)this.positionXField);
        this.selectableWidgets.add((AbstractWidget)this.positionYField);
        this.selectableWidgets.add((AbstractWidget)this.positionZField);
        this.selectableWidgets.add((AbstractWidget)this.positionXVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.positionYVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.positionZVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.velocityXField);
        this.selectableWidgets.add((AbstractWidget)this.velocityYField);
        this.selectableWidgets.add((AbstractWidget)this.velocityZField);
        this.selectableWidgets.add((AbstractWidget)this.velocityXVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.velocityYVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.velocityZVarianceField);
        this.selectableWidgets.add((AbstractWidget)this.scale);
        this.selectableWidgets.add((AbstractWidget)this.scaleVariance);
        this.selectableWidgets.add((AbstractWidget)this.duration);
        this.selectableWidgets.add((AbstractWidget)this.durationVariance);
        this.selectableWidgets.add((AbstractWidget)this.gravity);
        this.selectableWidgets.add((AbstractWidget)this.collisionsButton);
        this.backButton = Button.builder((Component)Component.translatable((String)"gui.pastel.button.back"), this::navigationButtonPressed).size(12, 14).pos(startX + 11, startY + 19).build();
        this.addWidget((GuiEventListener)this.backButton);
        this.forwardButton = Button.builder((Component)Component.translatable((String)"gui.pastel.button.forward"), this::navigationButtonPressed).size(12, 14).pos(startX + 147, startY + 19).build();
        this.addWidget((GuiEventListener)this.forwardButton);
        this.particleButtons = List.of(this.addParticleButton(startX + 23, startY + 16), this.addParticleButton(startX + 23 + 20, startY + 16), this.addParticleButton(startX + 23 + 40, startY + 16), this.addParticleButton(startX + 23 + 60, startY + 16), this.addParticleButton(startX + 23 + 80, startY + 16), this.addParticleButton(startX + 23 + 100, startY + 16));
        this.particleSelectionIndex = 0;
        int particleIndex = 0;
        for (ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry availableParticle : this.displayedParticleEntries) {
            if (availableParticle.particleType().equals(configuration.particleType())) {
                this.particleSelectionIndex = particleIndex;
                break;
            }
            ++particleIndex;
        }
        if (this.displayedParticleEntries.isEmpty()) {
            this.setColoringEnabled(false);
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(this.particleSelectionIndex);
        this.setColoringEnabled(entry.supportsColoring());
    }

    private void navigationButtonPressed(Button buttonWidget) {
        int pageCount = this.displayedParticleEntries.size() / 6;
        if (pageCount == 0) {
            return;
        }
        this.activeParticlePage = buttonWidget == this.forwardButton ? (this.activeParticlePage + 1) % pageCount : (this.activeParticlePage - 1 + pageCount) % pageCount;
    }

    @NotNull
    private EditBox addTextFieldWidget(int x, int y, Component text, String defaultText, Predicate<String> textPredicate) {
        EditBox textFieldWidget = new EditBox(this.font, x, y, 31, 16, text);
        textFieldWidget.setFilter(textPredicate);
        textFieldWidget.setCanLoseFocus(true);
        textFieldWidget.setEditable(true);
        textFieldWidget.setTextColor(-1);
        textFieldWidget.setTextColorUneditable(-1);
        textFieldWidget.setBordered(false);
        textFieldWidget.setMaxLength(6);
        textFieldWidget.setValue(defaultText);
        textFieldWidget.setResponder(this::onTextBoxValueChanged);
        this.addWidget((GuiEventListener)textFieldWidget);
        return textFieldWidget;
    }

    @NotNull
    private Button addParticleButton(int x, int y) {
        Button button = Button.builder((Component)Component.translatable((String)"gui.pastel.button.particles"), this::particleButtonPressed).size(20, 20).pos(x, y).build();
        this.addWidget((GuiEventListener)button);
        return button;
    }

    private void particleButtonPressed(Button buttonWidget) {
        int buttonIndex = this.particleButtons.indexOf(buttonWidget);
        int newIndex = 6 * this.activeParticlePage + buttonIndex;
        if (newIndex >= this.displayedParticleEntries.size()) {
            return;
        }
        ParticleSpawnerParticlesDataLoader.ParticleSpawnerEntry entry = this.displayedParticleEntries.get(newIndex);
        this.setColoringEnabled(entry.supportsColoring());
        if (newIndex < this.displayedParticleEntries.size()) {
            this.particleSelectionIndex = newIndex;
            this.onValuesChanged();
        }
    }

    private void setColoringEnabled(boolean enabled) {
        this.selectedParticleSupportsColoring = enabled;
        this.cyanField.setEditable(enabled);
        this.magentaField.setEditable(enabled);
        this.yellowField.setEditable(enabled);
        this.cyanField.setCanLoseFocus(enabled);
        this.magentaField.setCanLoseFocus(enabled);
        this.yellowField.setCanLoseFocus(enabled);
        this.cyanField.setResponder(enabled ? this::onTextBoxValueChanged : null);
        this.magentaField.setResponder(enabled ? this::onTextBoxValueChanged : null);
        this.yellowField.setResponder(enabled ? this::onTextBoxValueChanged : null);
        this.setFocused((GuiEventListener)this.amountField);
    }

    private void collisionButtonPressed(Button buttonWidget) {
        this.collisionsEnabled = !this.collisionsEnabled;
        this.onValuesChanged();
    }

    private void glowingButtonPressed(Button buttonWidget) {
        this.glowing = !this.glowing;
        this.onValuesChanged();
    }

    private void onTextBoxValueChanged(@NotNull String newValue) {
        this.onValuesChanged();
    }

    private boolean isPositiveDecimalNumberUnderThousand(String text) {
        try {
            return Double.parseDouble(text) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isAbsoluteDecimalNumberThousand(String text) {
        try {
            return Math.abs(Double.parseDouble(text)) < 1000.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumber100(String text) {
        try {
            int number = Integer.parseInt(text);
            return number >= 0 && number <= 100;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean isPositiveDecimalNumberUnderTen(String text) {
        try {
            return Double.parseDouble(text) < 10.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isPositiveWholeNumberUnderThousand(@NotNull String text) {
        try {
            return Integer.parseInt(text) < 1000;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected boolean isBetweenZeroAndOne(@NotNull String text) {
        try {
            float f = Float.parseFloat(text);
            return f >= 0.0f && f <= 1.0f;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void onValuesChanged() {
        try {
            ParticleSpawnerConfiguration configuration = new ParticleSpawnerConfiguration(this.displayedParticleEntries.get(this.particleSelectionIndex).particleType(), this.selectedParticleSupportsColoring ? new Vec3i(Math.round(Float.parseFloat(this.cyanField.getValue())), Math.round(Float.parseFloat(this.magentaField.getValue())), Math.round(Float.parseFloat(this.yellowField.getValue()))) : new Vec3i(0, 0, 0), this.glowing, Float.parseFloat(this.amountField.getValue()), new Vec3(Double.parseDouble(this.positionXField.getValue()), Double.parseDouble(this.positionYField.getValue()), Double.parseDouble(this.positionZField.getValue())), new Vec3(Double.parseDouble(this.positionXVarianceField.getValue()), Double.parseDouble(this.positionYVarianceField.getValue()), Double.parseDouble(this.positionZVarianceField.getValue())), new Vec3(Double.parseDouble(this.velocityXField.getValue()), Double.parseDouble(this.velocityYField.getValue()), Double.parseDouble(this.velocityZField.getValue())), new Vec3(Double.parseDouble(this.velocityXVarianceField.getValue()), Double.parseDouble(this.velocityYVarianceField.getValue()), Double.parseDouble(this.velocityZVarianceField.getValue())), Float.parseFloat(this.scale.getValue()), Float.parseFloat(this.scaleVariance.getValue()), Integer.parseInt(this.duration.getValue()), Integer.parseInt(this.durationVariance.getValue()), Float.parseFloat(this.gravity.getValue()), this.collisionsEnabled);
            PacketDistributor.sendToServer((CustomPacketPayload)new ParticleSpawnerConfigurationC2SPayload(configuration), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

