/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.ScreenBackgroundVariant;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GenericPastelContainerScreenHandler
extends ChestMenu {
    private final ScreenBackgroundVariant tier;

    private GenericPastelContainerScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, int columns, int rows, ScreenBackgroundVariant tier) {
        this(type, syncId, playerInventory, (Container)new SimpleContainer(columns * rows), rows, tier);
    }

    public GenericPastelContainerScreenHandler(MenuType<?> type, int syncId, Inventory playerInventory, Container inventory, int rows, ScreenBackgroundVariant tier) {
        super(type, syncId, playerInventory, inventory, rows);
        this.tier = tier;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x3_Tier1(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_9X3, syncId, playerInventory, 9, 3, ScreenBackgroundVariant.EARLYGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x3_Tier2(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER2_9X3, syncId, playerInventory, 9, 3, ScreenBackgroundVariant.MIDGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x3_Tier3(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER3_9X3, syncId, playerInventory, 9, 3, ScreenBackgroundVariant.LATEGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x6_Tier1(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_9X6, syncId, playerInventory, 9, 6, ScreenBackgroundVariant.EARLYGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x6_Tier2(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER2_9X6, syncId, playerInventory, 9, 6, ScreenBackgroundVariant.MIDGAME);
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x6_Tier3(int syncId, Inventory playerInventory) {
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER3_9X6, syncId, playerInventory, 9, 6, ScreenBackgroundVariant.LATEGAME);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x3(int syncId, Inventory playerInventory, Container inventory, @NotNull ScreenBackgroundVariant tier) {
        switch (tier) {
            case EARLYGAME: {
                return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_9X3, syncId, playerInventory, inventory, 3, tier);
            }
            case MIDGAME: {
                return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER2_9X3, syncId, playerInventory, inventory, 3, tier);
            }
        }
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER3_9X3, syncId, playerInventory, inventory, 3, tier);
    }

    @Contract(value="_, _, _, _ -> new")
    @NotNull
    public static GenericPastelContainerScreenHandler createGeneric9x6(int syncId, Inventory playerInventory, Container inventory, @NotNull ScreenBackgroundVariant tier) {
        switch (tier) {
            case EARLYGAME: {
                return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER1_9X6, syncId, playerInventory, inventory, 6, tier);
            }
            case MIDGAME: {
                return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER2_9X6, syncId, playerInventory, inventory, 6, tier);
            }
        }
        return new GenericPastelContainerScreenHandler(PastelScreenHandlerTypes.GENERIC_TIER3_9X6, syncId, playerInventory, inventory, 6, tier);
    }

    public ScreenBackgroundVariant getTier() {
        return this.tier;
    }
}

