/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.pedestal.PedestalRecipeInput;
import earth.terrarium.pastel.inventories.CraftingTabletInventory;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.inventories.slots.LockableCraftingResultSlot;
import earth.terrarium.pastel.inventories.slots.ReadOnlySlot;
import earth.terrarium.pastel.items.magic_items.CraftingTabletItem;
import earth.terrarium.pastel.recipe.pedestal.PastelGemstoneColor;
import earth.terrarium.pastel.recipe.pedestal.PedestalRecipe;
import earth.terrarium.pastel.recipe.pedestal.PedestalTier;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelRecipeTypes;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CraftingTabletScreenHandler
extends RecipeBookMenu<RecipeInput, Recipe<RecipeInput>> {
    private final CraftingTabletInventory craftingInventory = new CraftingTabletInventory((AbstractContainerMenu)this);
    private final ResultContainer craftingResultInventory = new ResultContainer();
    private final ContainerLevelAccess context;
    private final Player player;
    private final Level world;
    private final ItemStack craftingTabletItemStack;
    private final Optional<PedestalTier> highestUnlockedRecipeTier;
    private final LockableCraftingResultSlot lockableCraftingResultSlot;

    public CraftingTabletScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL, null);
    }

    public CraftingTabletScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context, ItemStack craftingTabletItemStack) {
        super(PastelScreenHandlerTypes.CRAFTING_TABLET, syncId);
        int l;
        this.context = context;
        this.world = playerInventory.player.getCommandSenderWorld();
        this.craftingTabletItemStack = craftingTabletItemStack;
        this.player = playerInventory.player;
        this.highestUnlockedRecipeTier = PedestalTier.getHighestUnlockedRecipeTier(playerInventory.player);
        for (int m = 0; m < 3; ++m) {
            for (int n = 0; n < 3; ++n) {
                this.addSlot(new Slot((Container)this.craftingInventory, n + m * 3, 30 + n * 18, 19 + m * 18));
            }
        }
        if (this.highestUnlockedRecipeTier.isPresent()) {
            switch (this.highestUnlockedRecipeTier.get()) {
                case COMPLEX: {
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 9, 44, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 10, 62, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 11, 80, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 12, 98, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 13, 116, 77));
                    break;
                }
                case ADVANCED: {
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 9, 53, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 10, 71, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 11, 89, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 12, 107, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 13, -2000, 77));
                    break;
                }
                default: {
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 9, 62, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 10, 80, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 11, 98, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 12, -2000, 77));
                    this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 13, -2000, 77));
                    break;
                }
            }
        } else {
            this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 9, 62, 77));
            this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 10, 80, 77));
            this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 11, 98, 77));
            this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 12, -2000, 77));
            this.addSlot(new ReadOnlySlot((Container)this.craftingInventory, 13, -2000, 77));
        }
        this.lockableCraftingResultSlot = new LockableCraftingResultSlot((Container)this.craftingResultInventory, 0, 127, 37, playerInventory.player, this.craftingInventory);
        this.addSlot((Slot)this.lockableCraftingResultSlot);
        for (l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + l * 9 + 9, 8 + k * 18, 112 + l * 18));
            }
        }
        for (l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInventory, l, 8 + l * 18, 170));
        }
    }

    protected void updateResult(AbstractContainerMenu handler, @NotNull Level world, Player player, CraftingTabletInventory inventory) {
        if (!world.isClientSide) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            PedestalRecipeInput pedestalRecipeInput = PedestalRecipeInput.createWithFullGemstonePowder(inventory.getItems(), player);
            Optional optionalPedestalCraftingRecipe = world.getRecipeManager().getRecipeFor(PastelRecipeTypes.PEDESTAL, (RecipeInput)pedestalRecipeInput, world);
            if (optionalPedestalCraftingRecipe.isPresent()) {
                this.lockableCraftingResultSlot.lock();
                PedestalRecipe pedestalRecipe = (PedestalRecipe)((RecipeHolder)optionalPedestalCraftingRecipe.get()).value();
                ItemStack itemStack = pedestalRecipe.getResultItem((HolderLookup.Provider)world.registryAccess()).copy();
                this.craftingResultInventory.setItem(0, itemStack);
                int magenta = pedestalRecipe.getPowder(PastelGemstoneColor.CYAN);
                if (magenta > 0) {
                    inventory.setItem(9, new ItemStack((ItemLike)PastelItems.TOPAZ_POWDER.get(), magenta));
                } else {
                    inventory.setItem(9, ItemStack.EMPTY);
                }
                int yellow = pedestalRecipe.getPowder(PastelGemstoneColor.MAGENTA);
                if (yellow > 0) {
                    inventory.setItem(10, new ItemStack((ItemLike)PastelItems.AMETHYST_POWDER.get(), yellow));
                } else {
                    inventory.setItem(10, ItemStack.EMPTY);
                }
                int cyan = pedestalRecipe.getPowder(PastelGemstoneColor.YELLOW);
                if (cyan > 0) {
                    inventory.setItem(11, new ItemStack((ItemLike)PastelItems.CITRINE_POWDER.get(), cyan));
                } else {
                    inventory.setItem(11, ItemStack.EMPTY);
                }
                int black = pedestalRecipe.getPowder(PastelGemstoneColor.BLACK);
                if (black > 0) {
                    inventory.setItem(12, new ItemStack((ItemLike)PastelItems.ONYX_POWDER.get(), black));
                } else {
                    inventory.setItem(12, ItemStack.EMPTY);
                }
                int white = pedestalRecipe.getPowder(PastelGemstoneColor.WHITE);
                if (white > 0) {
                    inventory.setItem(13, new ItemStack((ItemLike)PastelItems.MOONSTONE_POWDER.get(), white));
                } else {
                    inventory.setItem(13, ItemStack.EMPTY);
                }
                handler.setRemoteSlot(0, itemStack);
                serverPlayerEntity.connection.send((Packet)new ClientboundContainerSetSlotPacket(handler.containerId, handler.incrementStateId(), 14, itemStack));
                CraftingTabletItem.setStoredRecipe(this.craftingTabletItemStack, (RecipeHolder)optionalPedestalCraftingRecipe.get());
            } else {
                inventory.setItem(9, ItemStack.EMPTY);
                inventory.setItem(10, ItemStack.EMPTY);
                inventory.setItem(11, ItemStack.EMPTY);
                inventory.setItem(12, ItemStack.EMPTY);
                inventory.setItem(13, ItemStack.EMPTY);
                ItemStack itemStack = ItemStack.EMPTY;
                Optional optionalCraftingRecipe = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)pedestalRecipeInput.getCraftingGridInput(), world);
                if (optionalCraftingRecipe.isPresent()) {
                    this.lockableCraftingResultSlot.unlock();
                    if (this.craftingResultInventory.setRecipeUsed(world, serverPlayerEntity, (RecipeHolder)optionalCraftingRecipe.get())) {
                        itemStack = ((CraftingRecipe)((RecipeHolder)optionalCraftingRecipe.get()).value()).assemble((RecipeInput)pedestalRecipeInput.getCraftingGridInput(), (HolderLookup.Provider)world.registryAccess());
                    }
                    CraftingTabletItem.setStoredRecipe(this.craftingTabletItemStack, (RecipeHolder)optionalCraftingRecipe.get());
                } else {
                    CraftingTabletItem.clearStoredRecipe(this.craftingTabletItemStack);
                }
                this.craftingResultInventory.setItem(0, itemStack);
                handler.setRemoteSlot(0, itemStack);
                serverPlayerEntity.connection.send((Packet)new ClientboundContainerSetSlotPacket(handler.containerId, handler.incrementStateId(), 14, itemStack));
            }
        }
    }

    public void slotsChanged(Container inventory) {
        this.context.execute((world, pos) -> this.updateResult((AbstractContainerMenu)this, (Level)world, this.player, this.craftingInventory));
    }

    public void fillCraftSlotsStackedContents(StackedContents recipeMatcher) {
        if (this.craftingInventory != null) {
            this.craftingInventory.fillStackedContents(recipeMatcher);
        }
    }

    public void clearCraftingContent() {
        this.craftingInventory.clearContent();
    }

    public boolean recipeMatches(RecipeHolder recipe) {
        PedestalRecipeInput pedestalRecipeInput = PedestalRecipeInput.createWithFullGemstonePowder(this.craftingInventory.getItems(), this.player);
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof PedestalRecipe) {
            PedestalRecipe pedestalRecipe = (PedestalRecipe)recipe2;
            return pedestalRecipe.matches(pedestalRecipeInput, this.world);
        }
        recipe2 = recipe.value();
        if (recipe2 instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe2;
            return craftingRecipe.matches((RecipeInput)pedestalRecipeInput.getCraftingGridInput(), this.world);
        }
        return false;
    }

    public void removed(Player playerEntity) {
        for (int i = 0; i < 9; ++i) {
            ItemEntity itemEntity;
            ItemStack itemStack = this.craftingInventory.getItem(i);
            if (itemStack.isEmpty()) continue;
            boolean insertInventorySuccess = playerEntity.getInventory().add(itemStack);
            if (insertInventorySuccess && itemStack.isEmpty()) {
                itemStack.setCount(1);
                itemEntity = playerEntity.drop(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.makeFakeItem();
                }
                playerEntity.level().playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((playerEntity.getRandom().nextFloat() - playerEntity.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                playerEntity.containerMenu.broadcastChanges();
                continue;
            }
            itemEntity = playerEntity.drop(itemStack, false);
            if (itemEntity == null) continue;
            itemEntity.setNoPickUpDelay();
            itemEntity.setTarget(playerEntity.getUUID());
        }
        super.removed(this.player);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack transferStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack clickedSlotStack = slot.getItem();
            transferStack = clickedSlotStack.copy();
            if (index == 14) {
                this.context.execute((world, pos) -> clickedSlotStack.getItem().onCraftedBy(clickedSlotStack, world, player));
                if (!this.moveItemStackTo(clickedSlotStack, 42, 51, false) && !this.moveItemStackTo(clickedSlotStack, 15, 42, false)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(clickedSlotStack, transferStack);
            } else if (index < 9) {
                if (!this.moveItemStackTo(clickedSlotStack, 42, 51, false) && !this.moveItemStackTo(clickedSlotStack, 15, 42, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (index < 14) {
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(clickedSlotStack, 0, 9, false)) {
                    return ItemStack.EMPTY;
                }
            }
            if (clickedSlotStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (clickedSlotStack.getCount() == transferStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, clickedSlotStack);
            if (index == 14) {
                player.drop(clickedSlotStack, false);
            }
        }
        return transferStack;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return super.canTakeItemForPickAll(stack, slot);
    }

    public int getResultSlotIndex() {
        return 14;
    }

    public int getGridWidth() {
        return 3;
    }

    public int getGridHeight() {
        return 3;
    }

    public int getSize() {
        return 9;
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int index) {
        return index != this.getResultSlotIndex();
    }

    public Optional<PedestalTier> getTier() {
        return this.highestUnlockedRecipeTier;
    }
}

