/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.blocks.chests.CompactingChestBlockEntity;
import earth.terrarium.pastel.inventories.AutoCraftingMode;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.networking.c2s_payloads.ChangeCompactingChestSettingsPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class CompactingChestScreenHandler
extends AbstractContainerMenu {
    private final ContainerData propertyDelegate;
    private final CompactingChestBlockEntity blockEntity;
    protected final int ROWS = 3;

    public CompactingChestScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (CompactingChestBlockEntity)playerInventory.player.level().getBlockEntity((BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf)), (ContainerData)new SimpleContainerData(1));
    }

    public CompactingChestScreenHandler(int syncId, Inventory playerInventory, CompactingChestBlockEntity blockEntity, ContainerData propertyDelegate) {
        super(PastelScreenHandlerTypes.COMPACTING_CHEST, syncId);
        int k;
        int j;
        this.blockEntity = blockEntity;
        this.propertyDelegate = propertyDelegate;
        CompactingChestScreenHandler.checkContainerSize((Container)blockEntity, (int)27);
        blockEntity.startOpen(playerInventory.player);
        int i = -18;
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)blockEntity, k + j * 9, 8 + k * 18, 26 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 112 + j * 18 + i));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 170 + i));
        }
        this.addDataSlots(propertyDelegate);
    }

    public boolean stillValid(Player player) {
        return this.blockEntity.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemStack2 = slot.getItem();
            itemStack = itemStack2.copy();
            if (index < this.ROWS * 9 ? !this.moveItemStackTo(itemStack2, this.ROWS * 9, this.slots.size(), true) : !this.moveItemStackTo(itemStack2, 0, this.ROWS * 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemStack;
    }

    public void toggleMode() {
        this.propertyDelegate.set(0, this.getCraftingMode().next().ordinal());
        this.broadcastChanges();
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity.getLevel().isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ChangeCompactingChestSettingsPayload(this.getCraftingMode()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.blockEntity.applySettings(this.getCraftingMode());
    }

    public void removed(Player player) {
        super.removed(player);
        this.blockEntity.stopOpen(player);
    }

    public Container getInventory() {
        return this.blockEntity;
    }

    public CompactingChestBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public AutoCraftingMode getCraftingMode() {
        return AutoCraftingMode.values()[this.propertyDelegate.get(0)];
    }
}

