/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.api.energy.color.InkColors;
import earth.terrarium.pastel.blocks.cinderhearth.CinderhearthBlockEntity;
import earth.terrarium.pastel.inventories.CinderhearthScreenHandler;
import earth.terrarium.pastel.inventories.widgets.InkMeterWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CinderhearthScreen
extends AbstractContainerScreen<CinderhearthScreenHandler> {
    protected final ResourceLocation BACKGROUND = PastelCommon.locate("textures/gui/container/cinderhearth.png");
    protected InkMeterWidget inkMeterWidget;

    public CinderhearthScreen(CinderhearthScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        this.inkMeterWidget = new InkMeterWidget(startX + 140, startY + 34, 40, (Screen)this, ((CinderhearthScreenHandler)this.menu).getBlockEntity());
    }

    protected void renderLabels(GuiGraphics drawContext, int mouseX, int mouseY) {
        int titleX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int titleY = 6;
        Component title = this.title;
        drawContext.drawString(this.font, title, titleX, titleY, 0x323232, false);
        drawContext.drawString(this.font, this.playerInventoryTitle, 8, 74, 0x323232, false);
    }

    protected void renderBg(GuiGraphics drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        drawContext.blit(this.BACKGROUND, startX, startY, 0, 0, this.imageWidth, this.imageHeight);
        this.inkMeterWidget.draw(drawContext, CinderhearthBlockEntity.USED_INK_COLORS);
        int craftingTime = ((CinderhearthScreenHandler)this.menu).getCraftingTime();
        int craftingTimeTotal = ((CinderhearthScreenHandler)this.menu).getCraftingTimeTotal();
        if (((CinderhearthScreenHandler)this.menu).getBlockEntity().getEnergyStorage().getEnergy(InkColors.ORANGE) > 0L) {
            drawContext.blit(this.BACKGROUND, this.leftPos + 14, this.topPos + 62, 176, 14, 15, 2);
        }
        if (craftingTimeTotal > 0) {
            drawContext.blit(this.BACKGROUND, this.leftPos + 15, this.topPos + 48, 176, 0, 14, 14);
            drawContext.blit(this.BACKGROUND, this.leftPos + 35, this.topPos + 32, 176, 16, craftingTime * 22 / craftingTimeTotal, 16);
        }
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        this.renderBackground(drawContext, mouseX, mouseY, delta);
        super.render(drawContext, mouseX, mouseY, delta);
        this.renderTooltip(drawContext, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics drawContext, int x, int y) {
        if (this.inkMeterWidget.isMouseOver(x, y)) {
            this.inkMeterWidget.drawMouseoverTooltip(drawContext, x, y);
        } else {
            super.renderTooltip(drawContext, x, y);
        }
    }
}

