/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.inventories;

import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.render.LoreHelper;
import earth.terrarium.pastel.inventories.PastelScreenHandlerTypes;
import earth.terrarium.pastel.items.PigmentItem;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BedrockAnvilScreenHandler
extends ItemCombinerMenu {
    public static final int MAX_LORE_LENGTH = 200;
    public static final int FIRST_INPUT_SLOT_INDEX = 0;
    public static final int SECOND_INPUT_SLOT_INDEX = 1;
    public static final int OUTPUT_SLOT_INDEX = 2;
    private final DataSlot levelCost = DataSlot.standalone();
    private int repairItemCount;
    private String newItemName;
    private String newLoreString;

    public BedrockAnvilScreenHandler(int syncId, Inventory inventory) {
        this(syncId, inventory, ContainerLevelAccess.NULL);
    }

    public BedrockAnvilScreenHandler(int syncId, Inventory inventory, ContainerLevelAccess context) {
        super(PastelScreenHandlerTypes.BEDROCK_ANVIL, syncId, inventory, context);
        this.addDataSlot(this.levelCost);
    }

    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, stack -> true).withSlot(1, 76, 47, stack -> true).withResultSlot(2, 134, 47).build();
    }

    public void createInventorySlots(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 108 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 166));
        }
    }

    protected boolean isValidBlock(BlockState state) {
        return state.is(BlockTags.ANVIL);
    }

    public static int getNextCost(int cost) {
        return cost * 2 + 1;
    }

    protected boolean mayPickup(Player player, boolean present) {
        return player.hasInfiniteMaterials() || player.experienceLevel >= this.levelCost.get();
    }

    protected void onTake(Player player, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            player.giveExperienceLevels(-this.levelCost.get());
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCount > 0) {
            ItemStack itemStack = this.inputSlots.getItem(1);
            if (!itemStack.isEmpty() && itemStack.getCount() > this.repairItemCount) {
                itemStack.shrink(this.repairItemCount);
                this.inputSlots.setItem(1, itemStack);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.levelCost.set(0);
        this.access.execute((world, pos) -> world.levelEvent(1030, pos, 0));
    }

    public void createResult() {
        boolean combined = false;
        ItemStack inputStack = this.inputSlots.getItem(0);
        this.levelCost.set(0);
        int enchantmentLevelCost = 0;
        long repairLevelCost = 0L;
        if (!inputStack.isEmpty() && EnchantmentHelper.canStoreEnchantments((ItemStack)inputStack)) {
            ItemStack outputStack = inputStack.copy();
            ItemStack repairSlotStack = this.inputSlots.getItem(1);
            ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)outputStack));
            repairLevelCost += (long)((Integer)inputStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue() + (long)((Integer)repairSlotStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)).intValue();
            this.repairItemCount = 0;
            boolean pigmentInRepairSlot = repairSlotStack.getItem() instanceof PigmentItem;
            if (pigmentInRepairSlot) {
                this.repairItemCount = 1;
            }
            if (!repairSlotStack.isEmpty()) {
                boolean enchantedBookInRepairSlot;
                combined = true;
                boolean enchantedBookInInputSlot = inputStack.is(Items.ENCHANTED_BOOK) && !inputStack.has(DataComponents.STORED_ENCHANTMENTS);
                boolean bl = enchantedBookInRepairSlot = repairSlotStack.is(Items.ENCHANTED_BOOK) && !inputStack.has(DataComponents.STORED_ENCHANTMENTS);
                if (outputStack.isDamageableItem() && outputStack.getItem().isValidRepairItem(inputStack, repairSlotStack)) {
                    int repairItemCount;
                    int toRepair = Math.min(outputStack.getDamageValue(), outputStack.getMaxDamage() / 4);
                    if (toRepair <= 0) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.levelCost.set(0);
                        return;
                    }
                    for (repairItemCount = 0; toRepair > 0 && repairItemCount < repairSlotStack.getCount(); ++repairItemCount) {
                        int newOutputStackDamage = outputStack.getDamageValue() - toRepair;
                        outputStack.setDamageValue(newOutputStackDamage);
                        ++enchantmentLevelCost;
                        toRepair = Math.min(outputStack.getDamageValue(), outputStack.getMaxDamage() / 4);
                    }
                    this.repairItemCount = repairItemCount;
                } else {
                    if (!(pigmentInRepairSlot || enchantedBookInRepairSlot || outputStack.is(repairSlotStack.getItem()) && outputStack.isDamageableItem())) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.levelCost.set(0);
                        return;
                    }
                    if (outputStack.isDamageableItem() && !enchantedBookInRepairSlot && !pigmentInRepairSlot) {
                        int inputItemDurability = inputStack.getMaxDamage() - inputStack.getDamageValue();
                        int repairItemDurability = repairSlotStack.getMaxDamage() - repairSlotStack.getDamageValue();
                        int toRepair = repairItemDurability + outputStack.getMaxDamage() * 12 / 100;
                        int outputItemDurability = inputItemDurability + toRepair;
                        int outputItemDamage = outputStack.getMaxDamage() - outputItemDurability;
                        if (outputItemDamage < 0) {
                            outputItemDamage = 0;
                        }
                        if (outputItemDamage < outputStack.getDamageValue()) {
                            outputStack.setDamageValue(outputItemDamage);
                            enchantmentLevelCost += 2;
                        }
                    }
                    ItemEnchantments itemEnchantmentsComponent = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)repairSlotStack);
                    boolean foundAcceptable = false;
                    boolean foundUnacceptable = false;
                    for (Object2IntMap.Entry entry : itemEnchantmentsComponent.entrySet()) {
                        boolean capToMaxLevel;
                        int newEnchantmentLevel;
                        Holder registryEntry = (Holder)entry.getKey();
                        int t = builder.getLevel(registryEntry);
                        newEnchantmentLevel = t == (newEnchantmentLevel = entry.getIntValue()) ? newEnchantmentLevel + 1 : Math.max(newEnchantmentLevel, t);
                        Enchantment enchantment = (Enchantment)registryEntry.value();
                        boolean itemStackIsAcceptableForStack = inputStack.supportsEnchantment(registryEntry);
                        if (this.player.getAbilities().instabuild || inputStack.is(Items.ENCHANTED_BOOK)) {
                            itemStackIsAcceptableForStack = true;
                        }
                        for (Holder registryEntry2 : builder.keySet()) {
                            if (registryEntry2.equals((Object)registryEntry) || Enchantment.areCompatible((Holder)registryEntry, (Holder)registryEntry2)) continue;
                            itemStackIsAcceptableForStack = false;
                            ++enchantmentLevelCost;
                        }
                        if (!itemStackIsAcceptableForStack) {
                            foundUnacceptable = true;
                            continue;
                        }
                        foundAcceptable = true;
                        boolean bl2 = capToMaxLevel = inputStack.is(Items.ENCHANTED_BOOK) && !inputStack.has(DataComponents.STORED_ENCHANTMENTS) || !PastelCommon.CONFIG.BedrockAnvilCanExceedMaxVanillaEnchantmentLevel;
                        if (capToMaxLevel && newEnchantmentLevel > enchantment.getMaxLevel()) {
                            newEnchantmentLevel = enchantment.getMaxLevel();
                        }
                        builder.set(registryEntry, newEnchantmentLevel);
                        int anvilCost = enchantment.getAnvilCost();
                        if (enchantedBookInRepairSlot) {
                            anvilCost = Math.max(1, anvilCost / 2);
                        }
                        enchantmentLevelCost += anvilCost * newEnchantmentLevel;
                        if (inputStack.getCount() <= 1) continue;
                        enchantmentLevelCost = 40;
                    }
                    if (foundUnacceptable && !foundAcceptable) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.levelCost.set(0);
                        return;
                    }
                }
            }
            if (this.newItemName != null && !StringUtil.isBlank((String)this.newItemName)) {
                if (!this.newItemName.equals(inputStack.getHoverName().getString())) {
                    MutableComponent inputText;
                    Component enchantedBookInRepairSlot = inputStack.getHoverName();
                    if (enchantedBookInRepairSlot instanceof MutableComponent && (inputText = (MutableComponent)enchantedBookInRepairSlot).getStyle().getColor() != null) {
                        outputStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.newItemName).setStyle(Style.EMPTY.withColor(inputText.getStyle().getColor())));
                    } else {
                        outputStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.newItemName));
                    }
                }
            } else if (inputStack.has(DataComponents.CUSTOM_NAME)) {
                outputStack.remove(DataComponents.CUSTOM_NAME);
            }
            Component text = outputStack.getHoverName();
            if (pigmentInRepairSlot && text instanceof MutableComponent) {
                MutableComponent mutableText = (MutableComponent)text;
                int newColor = ((PigmentItem)repairSlotStack.getItem()).getInkColor().getColorInt();
                MutableComponent newName = mutableText.setStyle(mutableText.getStyle().withColor(newColor));
                if (!newName.equals((Object)inputStack.getHoverName())) {
                    outputStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.newItemName).withColor(newColor));
                }
            }
            if (this.newLoreString != null && !StringUtil.isBlank((String)this.newLoreString)) {
                List<Component> lore = LoreHelper.getLoreTextArrayFromString(this.newLoreString);
                if (!LoreHelper.equalsLore(lore, inputStack)) {
                    LoreHelper.setLore(outputStack, lore);
                }
            } else if (LoreHelper.hasLore(inputStack)) {
                LoreHelper.removeLore(outputStack);
            }
            int totalCost = (int)Mth.clamp((long)(repairLevelCost + (long)enchantmentLevelCost), (long)0L, (long)Integer.MAX_VALUE);
            this.levelCost.set(totalCost);
            if (enchantmentLevelCost < 0) {
                outputStack = ItemStack.EMPTY;
            }
            if (!combined || pigmentInRepairSlot) {
                this.levelCost.set(0);
            } else if (!outputStack.isEmpty()) {
                int repairCost = (Integer)outputStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                if (repairCost < (Integer)repairSlotStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
                    repairCost = (Integer)repairSlotStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                }
                if (enchantmentLevelCost > 0) {
                    repairCost = BedrockAnvilScreenHandler.getNextCost(repairCost);
                    outputStack.set(DataComponents.REPAIR_COST, (Object)repairCost);
                }
                EnchantmentHelper.setEnchantments((ItemStack)outputStack, (ItemEnchantments)builder.toImmutable());
            }
            this.resultSlots.setItem(0, outputStack);
            this.broadcastChanges();
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.levelCost.set(0);
        }
    }

    public boolean setNewItemName(String newItemName) {
        String string = BedrockAnvilScreenHandler.sanitize(newItemName, 50);
        if (string != null && !string.equals(this.newItemName)) {
            this.newItemName = string;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemStack = this.getSlot(2).getItem();
                if (StringUtil.isBlank((String)string)) {
                    itemStack.remove(DataComponents.CUSTOM_NAME);
                } else {
                    itemStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)string));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String sanitize(String name, int maxLength) {
        String string = StringUtil.filterText((String)name);
        return string.length() <= maxLength ? string : null;
    }

    public boolean setNewItemLore(String newLoreString) {
        String string = BedrockAnvilScreenHandler.sanitize(newLoreString, 200);
        if (string != null && !string.equals(this.newLoreString)) {
            this.newLoreString = string;
            if (this.getSlot(2).hasItem()) {
                ItemStack itemStack = this.getSlot(2).getItem();
                if (StringUtils.isBlank((CharSequence)newLoreString)) {
                    LoreHelper.removeLore(itemStack);
                } else {
                    LoreHelper.setLore(itemStack, LoreHelper.getLoreTextArrayFromString(this.newLoreString));
                }
            }
            this.createResult();
            return true;
        }
        return false;
    }

    public int getLevelCost() {
        return this.levelCost.get();
    }
}

