/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class RenderHelper {
    public static final int GREEN_COLOR = 0x323232;

    public static void fillTriangle(PoseStack matrices, int p1x, int p1y, int p2x, int p2y, int p3x, int p3y, Vector3f color) {
        Matrix4f matrix = matrices.last().pose();
        float red = color.x();
        float green = color.y();
        float blue = color.z();
        float alpha = 1.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(matrix, (float)p1x, (float)p1y, 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, (float)p2x, (float)p2y, 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, (float)p3x, (float)p3y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void fillQuad(PoseStack matrices, int x, int y, int height, int width, Vector3f color) {
        Matrix4f matrix = matrices.last().pose();
        float red = color.x();
        float green = color.y();
        float blue = color.z();
        float alpha = 1.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        builder.addVertex(matrix, (float)x, (float)y, 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, (float)x, (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, (float)(x + width), (float)(y + height), 0.0f).setColor(red, green, blue, alpha);
        builder.addVertex(matrix, (float)(x + width), (float)y, 0.0f).setColor(red, green, blue, alpha);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void renderFlatTrans(PoseStack matrices, VertexConsumer vertices, boolean altAxis, float scale, float alpha, float uvOffset, int overlay) {
        float size = scale / 16.0f;
        matrices.translate(-size / 2.0f, -size / 2.0f, 0.0f);
        PoseStack.Pose peek = matrices.last();
        Matrix4f model = peek.pose();
        RenderHelper.renderSide(model, vertices, altAxis, alpha, uvOffset, scale, scale, 0.0f, size, 0.0f, size, overlay);
        matrices.translate(size / 2.0f, size / 2.0f, 0.0f);
    }

    public static void renderFlatTransWithZYOffset(PoseStack matrices, VertexConsumer vertices, boolean altAxis, float height, float scale, float alpha, float uvOffset, int overlay) {
        float size = scale / 16.0f;
        matrices.translate(-size / 2.0f, height /= 16.0f, -size / 2.0f);
        PoseStack.Pose peek = matrices.last();
        Matrix4f model = peek.pose();
        RenderHelper.renderSide(model, vertices, altAxis, alpha, uvOffset, scale, scale, 0.0f, size, 0.0f, size, overlay);
        matrices.translate(size / 2.0f, -height, size / 2.0f);
    }

    public static void renderFlatTransWithZYOffsetAndColor(PoseStack matrices, VertexConsumer vertices, boolean altAxis, float height, float scale, float alpha, float uvOffset, int overlay, float r, float g, float b) {
        float size = scale / 16.0f;
        matrices.translate(-size / 2.0f, height /= 16.0f, -size / 2.0f);
        PoseStack.Pose peek = matrices.last();
        Matrix4f model = peek.pose();
        RenderHelper.renderSide(model, vertices, altAxis, alpha, uvOffset, scale, scale, 0.0f, size, 0.0f, size, r, g, b, overlay);
        matrices.translate(size / 2.0f, -height, size / 2.0f);
    }

    public static void renderSide(Matrix4f model, VertexConsumer vertices, boolean altAxis, float alpha, float uvOffset, float u, float v, float x1, float x2, float y1, float y2, float r, float g, float b, int overlay) {
        float u1 = uvOffset / 16.0f;
        float v1 = uvOffset / 16.0f;
        float u2 = u1 + u / 16.0f;
        float v2 = v1 + v / 16.0f;
        if (altAxis) {
            vertices.addVertex(model, x1, 0.0f, y2).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x2, 0.0f, y2).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x2, 0.0f, y1).setColor(r, g, b, alpha).setUv(u2, v2).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x1, 0.0f, y1).setColor(r, g, b, alpha).setUv(u1, v2).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        } else {
            vertices.addVertex(model, x1, y2, 0.0f).setColor(r, g, b, alpha).setUv(u1, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x2, y2, 0.0f).setColor(r, g, b, alpha).setUv(u2, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x2, y1, 0.0f).setColor(r, g, b, alpha).setUv(u2, v2).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertices.addVertex(model, x1, y1, 0.0f).setColor(r, g, b, alpha).setUv(u1, v2).setOverlay(overlay).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    public static void renderSide(Matrix4f model, VertexConsumer vertices, boolean altAxis, float alpha, float uvOffset, float u, float v, float x1, float x2, float y1, float y2, int overlay) {
        RenderHelper.renderSide(model, vertices, altAxis, alpha, uvOffset, u, v, x1, x2, y1, y2, 1.0f, 1.0f, 1.0f, overlay);
    }
}

