/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import earth.terrarium.pastel.api.interaction.ItemProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Triplet;

public class BuildingHelper {
    private static final Map<TagKey<Block>, List<Block>> SIMILAR_BLOCKS = new HashMap<TagKey<Block>, List<Block>>(){
        {
            this.put(BlockTags.DIRT, new ArrayList<Block>(){
                {
                    this.add(Blocks.GRASS_BLOCK);
                }
            });
            this.put(BlockTags.NYLIUM, new ArrayList<Block>(){
                {
                    this.add(Blocks.NETHERRACK);
                }
            });
        }
    };
    private static final Map<Block, List<Block>> SIMILAR_BLOCKS_CACHE = new HashMap<Block, List<Block>>();
    private static final ArrayList<Vec3i> NEIGHBOR_VECTORS_Y = new ArrayList<Vec3i>(){
        {
            this.add(Direction.NORTH.getNormal());
            this.add(Direction.EAST.getNormal());
            this.add(Direction.SOUTH.getNormal());
            this.add(Direction.WEST.getNormal());
            this.add(Direction.WEST.getNormal().relative(Direction.NORTH));
            this.add(Direction.NORTH.getNormal().relative(Direction.EAST));
            this.add(Direction.EAST.getNormal().relative(Direction.SOUTH));
            this.add(Direction.SOUTH.getNormal().relative(Direction.WEST));
        }
    };

    public static Triplet<Block, Item, Integer> getBuildingItemCountInInventoryIncludingSimilars(Player player, Block block, long maxCount) {
        Item blockItem = block.asItem();
        if (blockItem instanceof ItemNameBlockItem) {
            ItemNameBlockItem aliasedBlockItem = (ItemNameBlockItem)blockItem;
            return new Triplet((Object)block, (Object)aliasedBlockItem, (Object)0);
        }
        for (Block similarBlock : BuildingHelper.getSimilarBlocks(block)) {
            Item similarBlockItem = similarBlock.asItem();
            Inventory playerInventory = player.getInventory();
            int similarCount = playerInventory.countItem(similarBlockItem);
            for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                ItemStack currentStack = playerInventory.getItem(i);
                ItemProvider itemProvider = (ItemProvider)currentStack.getCapability(ItemProvider.CAPABILITY);
                if (itemProvider == null) continue;
                similarCount += itemProvider.getItemCount(player, currentStack, similarBlockItem);
            }
            if (similarCount <= 0) continue;
            return new Triplet((Object)similarBlock, (Object)similarBlockItem, (Object)((int)Math.min((long)similarCount, maxCount)));
        }
        return new Triplet((Object)block, (Object)blockItem, (Object)0);
    }

    @NotNull
    public static List<BlockPos> getConnectedBlocks(@NotNull Level world, @NotNull BlockPos blockPos, long maxCount, int maxRange) {
        BlockPos currentPos;
        BlockState originState = world.getBlockState(blockPos);
        Block originBlock = originState.getBlock();
        ArrayList<BlockPos> connectedPositions = new ArrayList<BlockPos>();
        ArrayList<BlockPos> visitedPositions = new ArrayList<BlockPos>();
        LinkedList<BlockPos> positionsToVisit = new LinkedList<BlockPos>();
        connectedPositions.add(blockPos);
        visitedPositions.add(blockPos);
        positionsToVisit.add(blockPos);
        block0: while ((long)connectedPositions.size() < maxCount && (currentPos = (BlockPos)positionsToVisit.poll()) != null) {
            for (Direction direction : Direction.values()) {
                Block localBlock;
                BlockPos offsetPos = currentPos.relative(direction);
                if (visitedPositions.contains(offsetPos)) continue;
                visitedPositions.add(offsetPos);
                if (!blockPos.closerThan((Vec3i)offsetPos, (double)maxRange) || !BuildingHelper.getSimilarBlocks(localBlock = world.getBlockState(offsetPos).getBlock()).contains(originBlock)) continue;
                positionsToVisit.add(offsetPos);
                connectedPositions.add(offsetPos);
                if ((long)connectedPositions.size() >= maxCount) continue block0;
            }
        }
        return connectedPositions;
    }

    @NotNull
    public static List<BlockPos> calculateBuildingStaffSelection(@NotNull Level world, @NotNull BlockPos originPos, Direction direction, long maxCount, int maxRange, boolean sameBlockOnly) {
        BlockPos offsetPos = originPos.relative(direction);
        BlockState originState = world.getBlockState(originPos);
        ArrayList<BlockPos> selectedPositions = new ArrayList<BlockPos>();
        int count = 1;
        ArrayList<Object> storedNeighbors = new ArrayList<Object>();
        if (world.isUnobstructed(originState, offsetPos, CollisionContext.empty())) {
            storedNeighbors.add(offsetPos);
        }
        while ((long)count < maxCount && !storedNeighbors.isEmpty()) {
            selectedPositions.addAll(storedNeighbors);
            ArrayList<BlockPos> newNeighbors = new ArrayList<BlockPos>();
            for (BlockPos blockPos : storedNeighbors) {
                List<BlockPos> facingNeighbors = BuildingHelper.getValidNeighbors(world, blockPos, direction, originState, sameBlockOnly);
                for (BlockPos facingNeighbor : facingNeighbors) {
                    if ((long)count >= maxCount || !originPos.closerThan((Vec3i)facingNeighbor, (double)maxRange) || selectedPositions.contains(facingNeighbor) || storedNeighbors.contains(facingNeighbor) || newNeighbors.contains(facingNeighbor)) continue;
                    newNeighbors.add(facingNeighbor);
                    ++count;
                }
            }
            storedNeighbors.clear();
            storedNeighbors.addAll(newNeighbors);
        }
        selectedPositions.addAll(storedNeighbors);
        return selectedPositions;
    }

    @NotNull
    private static List<BlockPos> getValidNeighbors(Level world, BlockPos startPos, Direction facingDirection, BlockState originState, boolean similarBlockOnly) {
        ArrayList<BlockPos> foundNeighbors = new ArrayList<BlockPos>();
        for (Vec3i neighborVectors : BuildingHelper.getNeighborVectors(facingDirection)) {
            BlockPos targetPos = startPos.offset(neighborVectors);
            BlockState targetState = world.getBlockState(targetPos);
            BlockState facingAgainstState = world.getBlockState(targetPos.relative(facingDirection.getOpposite()));
            if (!targetState.canBeReplaced() && targetState.getFluidState().isEmpty() || !world.isUnobstructed(originState, targetPos, CollisionContext.empty())) continue;
            if (similarBlockOnly) {
                if (!BuildingHelper.getSimilarBlocks(facingAgainstState.getBlock()).contains(originState.getBlock())) continue;
                foundNeighbors.add(targetPos);
                continue;
            }
            if (facingAgainstState.isAir()) continue;
            foundNeighbors.add(targetPos);
        }
        return foundNeighbors;
    }

    @NotNull
    private static List<Vec3i> getNeighborVectors(final @NotNull Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return NEIGHBOR_VECTORS_Y;
        }
        return new ArrayList<Vec3i>(){
            {
                this.add(direction.getClockWise().getNormal());
                this.add(direction.getCounterClockWise().getNormal());
                this.add(Direction.UP.getNormal());
                this.add(Direction.DOWN.getNormal());
            }
        };
    }

    private static List<Block> getSimilarBlocks(final Block block) {
        ArrayList<Block> similarBlocks = SIMILAR_BLOCKS_CACHE.get(block);
        if (similarBlocks == null) {
            similarBlocks = new ArrayList<Block>(){
                {
                    this.add(block);
                    for (Map.Entry<TagKey<Block>, List<Block>> entry : SIMILAR_BLOCKS.entrySet()) {
                        if (!block.defaultBlockState().is(entry.getKey())) continue;
                        this.addAll((Collection)entry.getValue());
                    }
                }
            };
            SIMILAR_BLOCKS_CACHE.put(block, (List<Block>)similarBlocks);
        }
        return similarBlocks;
    }
}

