/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import earth.terrarium.pastel.registries.PastelBlockTags;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockVariantHelper {
    private static final Map<Block, Map<DyeColor, Block>> coloredStates = new HashMap<Block, Map<DyeColor, Block>>();
    private static final List<String> COLOR_STRINGS = List.of("light_blue", "light_gray", "white", "orange", "magenta", "yellow", "lime", "pink", "gray", "cyan", "purple", "blue", "brown", "green", "red", "black");
    private static final Map<Block, Block> repairedStates = new HashMap<Block, Block>(){
        {
            this.put(Blocks.CRACKED_DEEPSLATE_BRICKS, Blocks.DEEPSLATE_BRICKS);
            this.put(Blocks.CRACKED_DEEPSLATE_TILES, Blocks.DEEPSLATE_TILES);
            this.put(Blocks.CRACKED_NETHER_BRICKS, Blocks.NETHER_BRICKS);
            this.put(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, Blocks.POLISHED_BLACKSTONE_BRICKS);
            this.put(Blocks.CRACKED_STONE_BRICKS, Blocks.STONE_BRICKS);
            this.put(Blocks.INFESTED_CRACKED_STONE_BRICKS, Blocks.INFESTED_STONE_BRICKS);
            this.put(Blocks.DAMAGED_ANVIL, Blocks.CHIPPED_ANVIL);
            this.put(Blocks.CHIPPED_ANVIL, Blocks.ANVIL);
            this.put(Blocks.EXPOSED_COPPER, Blocks.COPPER_BLOCK);
            this.put(Blocks.WEATHERED_COPPER, Blocks.EXPOSED_COPPER);
            this.put(Blocks.OXIDIZED_COPPER, Blocks.WEATHERED_COPPER);
            this.put(Blocks.EXPOSED_CUT_COPPER, Blocks.CUT_COPPER);
            this.put(Blocks.WEATHERED_CUT_COPPER, Blocks.EXPOSED_CUT_COPPER);
            this.put(Blocks.OXIDIZED_CUT_COPPER, Blocks.WEATHERED_CUT_COPPER);
        }
    };

    public static BlockState getCursedBlockColorVariant(Level world, BlockPos blockPos, DyeColor newColor) {
        ResourceLocation newIdentifier;
        Block newIdentifierBlock;
        Map<DyeColor, Block> colorMap;
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity != null) {
            return Blocks.AIR.defaultBlockState();
        }
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(PastelBlockTags.INK_EFFECT_BLACKLISTED) || blockState.getDestroySpeed((BlockGetter)world, blockPos) == -1.0f) {
            return Blocks.AIR.defaultBlockState();
        }
        Block block = blockState.getBlock();
        if (coloredStates.containsKey(block) && (colorMap = coloredStates.get(block)).containsKey(newColor)) {
            Block newBlock = colorMap.get(newColor);
            return newBlock.withPropertiesOf(blockState);
        }
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        String newPath = null;
        for (String colorString : COLOR_STRINGS) {
            if (!identifier.getPath().contains(colorString)) continue;
            newPath = identifier.getPath().replace(colorString, newColor.toString());
            break;
        }
        Block returnBlock = Blocks.AIR;
        if (newPath != null && (newIdentifierBlock = (Block)BuiltInRegistries.BLOCK.get(newIdentifier = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), newPath))) != block) {
            returnBlock = newIdentifierBlock;
        }
        if (coloredStates.containsKey(block)) {
            colorMap = coloredStates.get(block);
            colorMap.put(newColor, returnBlock);
        } else {
            colorMap = new HashMap();
            colorMap.put(newColor, returnBlock);
            coloredStates.put(block, colorMap);
        }
        return returnBlock.withPropertiesOf(blockState);
    }

    public static Block getCursedRepairedBlockVariant(Level world, BlockPos blockPos) {
        ResourceLocation newIdentifier;
        Block newIdentifierBlock;
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity != null) {
            return Blocks.AIR;
        }
        BlockState blockState = world.getBlockState(blockPos);
        if (blockState.is(PastelBlockTags.INK_EFFECT_BLACKLISTED)) {
            return Blocks.AIR;
        }
        Block block = blockState.getBlock();
        if (repairedStates.containsKey(block)) {
            return repairedStates.get(block);
        }
        ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
        String newPath = identifier.getPath();
        newPath = newPath.replace("cracked_", "");
        newPath = newPath.replace("damaged_", "");
        newPath = newPath.replace("chipped_", "");
        Block returnBlock = Blocks.AIR;
        if (!newPath.equals(identifier.getPath()) && (newIdentifierBlock = (Block)BuiltInRegistries.BLOCK.get(newIdentifier = ResourceLocation.fromNamespaceAndPath((String)identifier.getNamespace(), (String)newPath))) != block) {
            returnBlock = newIdentifierBlock;
        }
        repairedStates.put(block, returnBlock);
        return returnBlock;
    }
}

