/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class BlockReference {
    private BlockState state;
    private final Optional<WeakReference<BlockEntity>> be;
    public final BlockPos pos;

    private BlockReference(BlockState state, Optional<BlockEntity> be, BlockPos pos) {
        this.state = state;
        this.be = be.map(WeakReference::new);
        this.pos = pos;
    }

    public static BlockReference of(BlockState state, BlockPos pos) {
        return new BlockReference(state, Optional.empty(), pos);
    }

    public static BlockReference of(LevelAccessor world, BlockPos pos) {
        return new BlockReference(world.getBlockState(pos), Optional.ofNullable(world.getBlockEntity(pos)), pos);
    }

    public BlockReference appendBE(BlockEntity entity) {
        return new BlockReference(this.state, Optional.of(entity), this.pos);
    }

    public BlockReference tryRecreateWithBE(LevelAccessor world) {
        return new BlockReference(this.state, Optional.ofNullable(world.getBlockEntity(this.pos)), this.pos);
    }

    public <V extends Comparable<V>> void setProperty(Property<V> property, V value) {
        this.state = (BlockState)this.state.setValue(property, value);
    }

    public <V extends Comparable<V>> V getProperty(Property<V> property) {
        return (V)this.state.getValue(property);
    }

    public BlockState getState() {
        return this.state;
    }

    public boolean exists() {
        return this.state != null && this.pos != null;
    }

    public boolean isOf(Block block) {
        return this.state.is(block);
    }

    public boolean isOf(BlockState blockState) {
        return this.state == blockState;
    }

    public boolean isIn(TagKey<Block> tag) {
        return this.state.is(tag);
    }

    public boolean validateBE() {
        return this.be.isPresent();
    }

    public Optional<BlockEntity> tryGetBlockEntity() {
        return this.be.map(Reference::get);
    }

    public void update(LevelAccessor world, int flags) {
        world.setBlock(this.pos, this.state, flags);
    }

    public void update(LevelAccessor world) {
        this.update(world, 3);
    }
}

