/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AoEHelper {
    private static boolean recursive = false;

    public static void doAoEBlockBreaking(Player player, ItemStack stack, BlockPos pos, Direction side, int radius) {
        if (radius <= 0) {
            return;
        }
        Level world = player.level();
        if (world.isEmptyBlock(pos)) {
            return;
        }
        Predicate<BlockState> minableBlocksPredicate = state -> {
            boolean suitableTool = !state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state);
            boolean suitableSpeed = stack.getDestroySpeed(state) > 1.0f;
            return suitableTool && suitableSpeed;
        };
        BlockState targetState = world.getBlockState(pos);
        if (!minableBlocksPredicate.test(targetState)) {
            return;
        }
        boolean doX = side.getStepX() == 0;
        boolean doY = side.getStepY() == 0;
        boolean doZ = side.getStepZ() == 0;
        Vec3i beginDiff = new Vec3i(doX ? -radius : 0, doY ? -1 : 0, doZ ? -radius : 0);
        Vec3i endDiff = new Vec3i(doX ? radius : 0, doY ? radius * 2 - 1 : 0, doZ ? radius : 0);
        AoEHelper.removeBlocksInIteration(player, stack, world, pos, beginDiff, endDiff, minableBlocksPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBlocksInIteration(Player player, ItemStack stack, Level world, BlockPos centerPos, Vec3i startDelta, Vec3i endDelta, Predicate<BlockState> filter) {
        if (recursive) {
            return;
        }
        recursive = true;
        try {
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)centerPos.offset(startDelta), (BlockPos)centerPos.offset(endDelta))) {
                if (blockPos.equals((Object)centerPos)) continue;
                AoEHelper.breakBlockWithDrops(player, stack, world, blockPos, filter);
            }
        }
        finally {
            recursive = false;
        }
    }

    public static void breakBlocksAround(Player player, ItemStack stack, BlockPos pos, int radius, @Nullable Predicate<BlockState> predicate) {
        BlockState targetState;
        if (radius <= 0) {
            return;
        }
        Level world = player.level();
        Predicate<BlockState> minableBlocksPredicate = state -> {
            boolean suitableTool = !state.requiresCorrectToolForDrops() || stack.isCorrectToolForDrops(state);
            boolean suitableSpeed = stack.getDestroySpeed(state) > 1.0f;
            return suitableTool && suitableSpeed;
        };
        if (predicate != null) {
            minableBlocksPredicate = minableBlocksPredicate.and(predicate);
        }
        if (!minableBlocksPredicate.test(targetState = world.getBlockState(pos))) {
            return;
        }
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)pos, (int)radius, (int)radius, (int)radius)) {
            AoEHelper.breakBlockWithDrops(player, stack, world, blockPos, minableBlocksPredicate);
        }
    }

    public static void breakBlockWithDrops(Player player, ItemStack stack, Level world, BlockPos pos, Predicate<BlockState> filter) {
        ChunkPos chunkPos = world.getChunk(pos).getPos();
        if (world.hasChunk(chunkPos.x, chunkPos.z)) {
            BlockState blockstate = world.getBlockState(pos);
            if (!world.isClientSide && !blockstate.isAir() && blockstate.getDestroyProgress(player, (BlockGetter)world, pos) > 0.0f && filter.test(blockstate)) {
                ItemStack save = player.getMainHandItem();
                player.setItemInHand(InteractionHand.MAIN_HAND, stack);
                ((ServerPlayer)player).connection.send((Packet)new ClientboundLevelEventPacket(2001, pos, Block.getId((BlockState)blockstate), false));
                ((ServerPlayer)player).gameMode.destroyBlock(pos);
                player.setItemInHand(InteractionHand.MAIN_HAND, save);
            }
        }
    }
}

