/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class Orientation {
    private final double longitude;
    private final double latitude;

    private Orientation(double longitude, double latitude) {
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public static Orientation create(double longitude, double latitude) {
        return new Orientation(longitude, latitude);
    }

    public static Orientation fromVector(Vec3 vector) {
        return Orientation.getVectorOrientation(vector);
    }

    public Vec3 toVector(double r) {
        return new Vec3(r * Math.sin(this.latitude) * Math.cos(this.longitude), r * Math.cos(this.latitude), r * Math.sin(this.latitude) * Math.sin(this.longitude));
    }

    public Orientation add(Orientation other) {
        return new Orientation(this.longitude + other.longitude, this.latitude + other.latitude);
    }

    public Orientation add(double longitude, double latitude) {
        return new Orientation(this.longitude + longitude, this.latitude + latitude);
    }

    public Orientation subtract(Orientation other) {
        return new Orientation(this.longitude - other.longitude, this.latitude - other.latitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public static Orientation getVectorOrientation(Vec3 vector) {
        double r = vector.length();
        double longitude = Mth.atan2((double)vector.z, (double)vector.x);
        double latitude = Math.acos(vector.y / r) - 1.5707963267948966;
        return Orientation.create(longitude, latitude *= -1.0);
    }

    public String toString() {
        return "{ Longitude: " + this.longitude + " rads | Latitude: " + this.latitude + " rads }";
    }
}

