/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import java.util.Iterator;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InWorldInteractionHelper {
    public static boolean findAndDecreaseClosestItemEntityOfItem(@NotNull ServerLevel world, Vec3 pos, Item item, int range) {
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)pos, (double)range, (double)range, (double)range));
        for (ItemEntity itemEntity : itemEntities) {
            if (!itemEntity.getItem().is(item)) continue;
            InWorldInteractionHelper.decrementAndSpawnRemainder(itemEntity, 1);
            return true;
        }
        return false;
    }

    public static boolean findAndDecreaseClosestItemEntityOfItem(@NotNull Level world, Vec3 pos, TagKey<Item> tag, int range, int count) {
        ItemEntity itemEntity2;
        ItemStack stack;
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)pos, (double)range, (double)range, (double)range));
        int foundCount = 0;
        Iterator iterator = itemEntities.iterator();
        while (iterator.hasNext() && (!(stack = (itemEntity2 = (ItemEntity)iterator.next()).getItem()).is(tag) || (foundCount += stack.getCount()) < count)) {
        }
        if (foundCount < count) {
            return false;
        }
        for (ItemEntity itemEntity2 : itemEntities) {
            stack = itemEntity2.getItem();
            if (!stack.is(tag)) continue;
            int decrementCount = Math.min(stack.getCount(), count);
            InWorldInteractionHelper.decrementAndSpawnRemainder(itemEntity2, decrementCount);
            if ((count -= decrementCount) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean findAndDecreaseClosestItemEntityOfItem(@NotNull Level world, Vec3 pos, Item item, int range, int count) {
        ItemEntity itemEntity2;
        ItemStack stack;
        List itemEntities = world.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)pos, (double)range, (double)range, (double)range));
        int foundCount = 0;
        Iterator iterator = itemEntities.iterator();
        while (iterator.hasNext() && (!(stack = (itemEntity2 = (ItemEntity)iterator.next()).getItem()).is(item) || (foundCount += stack.getCount()) < count)) {
        }
        if (foundCount < count) {
            return false;
        }
        for (ItemEntity itemEntity2 : itemEntities) {
            stack = itemEntity2.getItem();
            if (!stack.is(item)) continue;
            int decrementCount = Math.min(stack.getCount(), count);
            InWorldInteractionHelper.decrementAndSpawnRemainder(itemEntity2, decrementCount);
            if ((count -= decrementCount) != 0) continue;
            return true;
        }
        return false;
    }

    public static void decrementAndSpawnRemainder(ItemEntity itemEntity, int amount) {
        ItemStack remainder;
        ItemStack stack = itemEntity.getItem();
        ItemStack itemStack = remainder = stack.getItem() instanceof MobBucketItem ? Items.BUCKET.getDefaultInstance() : stack.getCraftingRemainingItem();
        if (!remainder.isEmpty()) {
            remainder.setCount(amount);
            ItemEntity remainderEntity = new ItemEntity(itemEntity.level(), itemEntity.position().x(), itemEntity.position().y(), itemEntity.position().z(), remainder);
            itemEntity.level().addFreshEntity((Entity)remainderEntity);
        }
        stack.shrink(amount);
    }

    public static void scatter(Level world, double x, double y, double z, ItemStack item, long amount) {
        int maxStackSize = item.getMaxStackSize();
        while (amount > 0L) {
            int stackSize = (int)Math.min((long)maxStackSize, amount);
            ItemStack stack = item.copyWithCount(stackSize);
            Containers.dropItemStack((Level)world, (double)x, (double)y, (double)z, (ItemStack)stack);
            amount -= (long)stackSize;
        }
    }
}

