/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.interaction;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public record CollisionResult<T>(Level world, T collision, CollisionType type, Vec3 collisionPoint) {
    public boolean sanityCheck() {
        if (this.type != CollisionType.BLOCK) {
            AABB collisionBox = ((Entity)this.collision).getBoundingBox();
            return collisionBox.contains(this.collisionPoint);
        }
        BlockPos pos = BlockPos.containing((Position)this.collisionPoint);
        return this.world.getBlockState(pos).getInteractionShape((BlockGetter)this.world, pos).toAabbs().stream().anyMatch(box -> box.contains(this.collisionPoint));
    }

    public static enum CollisionType {
        LIVING,
        NON_LIVING,
        BLOCK;

    }
}

