/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.enchantments;

import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.registries.PastelAttributeTags;
import earth.terrarium.pastel.registries.PastelEnchantments;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class InexorableHelper {
    public static void checkAndRemoveSlowdownModifiers(LivingEntity entity) {
        List<AttributeModifier> badMods;
        AttributeInstance attributeInstance;
        boolean armorInexorable = InexorableHelper.isArmorActive(entity);
        boolean toolInexorable = Ench.hasEnchantment((HolderLookup.Provider)entity.level().registryAccess(), PastelEnchantments.INEXORABLE, entity.getItemInHand(entity.getUsedItemHand()));
        Optional armorAttributes = BuiltInRegistries.ATTRIBUTE.getTag(PastelAttributeTags.INEXORABLE_ARMOR_EFFECTIVE);
        Optional toolAttributes = BuiltInRegistries.ATTRIBUTE.getTag(PastelAttributeTags.INEXORABLE_HANDHELD_EFFECTIVE);
        if (armorInexorable && armorAttributes.isPresent()) {
            for (Holder attributeRegistryEntry : (HolderSet.Named)armorAttributes.get()) {
                attributeInstance = entity.getAttribute(attributeRegistryEntry);
                if (attributeInstance == null) continue;
                badMods = attributeInstance.getModifiers().stream().filter(modifier -> modifier.amount() < 0.0).toList();
                badMods.forEach(modifier -> attributeInstance.removeModifier(modifier.id()));
            }
        }
        if (toolInexorable && toolAttributes.isPresent()) {
            for (Holder attributeRegistryEntry : (HolderSet.Named)toolAttributes.get()) {
                attributeInstance = entity.getAttribute(attributeRegistryEntry);
                if (attributeInstance == null) continue;
                badMods = attributeInstance.getModifiers().stream().filter(modifier -> modifier.amount() < 0.0).toList();
                badMods.forEach(modifier -> attributeInstance.removeModifier(modifier.id()));
            }
        }
    }

    public static boolean isArmorActive(LivingEntity entity) {
        return Ench.hasEnchantment((HolderLookup.Provider)entity.level().registryAccess(), PastelEnchantments.INEXORABLE, entity.getItemBySlot(EquipmentSlot.CHEST));
    }
}

