/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.enchantments;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoundryHelper {
    @Nullable
    public static ItemStack getSmeltedItemStack(ItemStack inputItemStack, Level world) {
        RegistryAccess drm = world.registryAccess();
        SingleRecipeInput input = new SingleRecipeInput(inputItemStack);
        return world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, world).map(recipe -> {
            ItemStack recipeOutputStack = ((SmeltingRecipe)recipe.value()).getResultItem((HolderLookup.Provider)drm).copy();
            recipeOutputStack.setCount(recipeOutputStack.getCount() * inputItemStack.getCount());
            return recipeOutputStack;
        }).orElse(null);
    }

    @NotNull
    public static List<ItemStack> applyFoundry(Level world, List<ItemStack> originalStacks) {
        ArrayList<ItemStack> returnItemStacks = new ArrayList<ItemStack>();
        for (ItemStack is : originalStacks) {
            ItemStack smeltedStack = FoundryHelper.getSmeltedItemStack(is, world);
            if (smeltedStack == null) {
                returnItemStacks.add(is);
                continue;
            }
            while (!smeltedStack.isEmpty()) {
                int currentAmount = Math.min(smeltedStack.getCount(), smeltedStack.getItem().getDefaultMaxStackSize());
                ItemStack currentStack = smeltedStack.copyWithCount(currentAmount);
                returnItemStacks.add(currentStack);
                smeltedStack.setCount(smeltedStack.getCount() - currentAmount);
            }
        }
        return returnItemStacks;
    }
}

