/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.enchantments;

import earth.terrarium.pastel.registries.PastelItemTags;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class Ench {
    public static Tuple<Boolean, ItemStack> addOrUpgradeEnchantment(HolderLookup.Provider registryLookup, ItemStack stack, ResourceKey<Enchantment> enchantmentKey, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        return Ench.getEntry(registryLookup, enchantmentKey).map(entry -> Ench.addOrUpgradeEnchantment(stack, (Holder<Enchantment>)entry, level, forceEvenIfNotApplicable, allowEnchantmentConflicts)).orElse(new Tuple((Object)false, (Object)stack));
    }

    public static Optional<ItemStack> addOrUpgradeEnchantmentOpt(HolderLookup.Provider registryLookup, ItemStack stack, ResourceKey<Enchantment> enchantmentKey, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        Tuple<Boolean, ItemStack> result = Ench.addOrUpgradeEnchantment(registryLookup, stack, enchantmentKey, level, forceEvenIfNotApplicable, allowEnchantmentConflicts);
        return (Boolean)result.getA() != false ? Optional.empty() : Optional.of((ItemStack)result.getB());
    }

    public static Tuple<Boolean, ItemStack> addOrUpgradeEnchantment(ItemStack stack, Holder<Enchantment> enchantment, int level, boolean forceEvenIfNotApplicable, boolean allowEnchantmentConflicts) {
        ItemEnchantments.Mutable builder;
        boolean isEnchantedBook;
        boolean isAcceptable = stack.supportsEnchantment(enchantment) || forceEvenIfNotApplicable;
        boolean isConflicting = !allowEnchantmentConflicts && !EnchantmentHelper.isEnchantmentCompatible((Collection)stack.getEnchantments().keySet(), enchantment);
        boolean bl = isEnchantedBook = stack.is(Items.ENCHANTED_BOOK) || Ench.isEnchantableBook(stack);
        if (!isAcceptable && !isEnchantedBook) {
            return new Tuple((Object)false, (Object)stack);
        }
        if (isConflicting) {
            return new Tuple((Object)false, (Object)stack);
        }
        if (isEnchantedBook && !stack.is(Items.ENCHANTED_BOOK)) {
            ItemStack enchantedBookStack = new ItemStack((ItemLike)Items.ENCHANTED_BOOK, stack.getCount());
            enchantedBookStack.applyComponentsAndValidate(stack.getComponentsPatch());
            stack = enchantedBookStack;
        }
        if (level <= (builder = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack))).getLevel(enchantment)) {
            return new Tuple((Object)false, (Object)stack);
        }
        builder.set(enchantment, level);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)builder.toImmutable());
        return new Tuple((Object)true, (Object)stack);
    }

    public static Object2IntMap<Holder<Enchantment>> getUsableEnchants(ItemStack source, ItemStack target, boolean permissive, boolean allowConflicts) {
        Object2IntArrayMap enchants = new Object2IntArrayMap();
        for (Object2IntMap.Entry entry : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)source).entrySet()) {
            Holder offering = (Holder)entry.getKey();
            int level = entry.getIntValue();
            if (!permissive && !target.supportsEnchantment(offering) || EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)target).getLevel(offering) >= level || !allowConflicts && !Ench.canCombineInto(target, (Holder<Enchantment>)offering)) continue;
            enchants.put((Object)offering, level);
        }
        return enchants;
    }

    public static boolean isEnchantableBook(@NotNull ItemStack stack) {
        return stack.is(PastelItemTags.ENCHANTABLE_BOOKS) || stack.getItem() instanceof BookItem;
    }

    public static ItemEnchantments collectHighestEnchantments(List<ItemStack> itemStacks) {
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (ItemStack itemStack : itemStacks) {
            for (Object2IntMap.Entry entry : EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack).entrySet()) {
                builder.upgrade((Holder)entry.getKey(), entry.getIntValue());
            }
        }
        return builder.toImmutable();
    }

    public static boolean canCombineInto(ItemStack stack, Holder<Enchantment> offering) {
        Set existingEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack).keySet();
        if (existingEnchantments.isEmpty()) {
            return true;
        }
        return EnchantmentHelper.isEnchantmentCompatible((Collection)existingEnchantments, offering);
    }

    public static int getEnchantmentCost(Holder<Enchantment> holder, int level, int enchantability) {
        Enchantment enchantment = (Enchantment)holder.value();
        int rarity = enchantment.getAnvilCost();
        float rarityMult = (float)Math.pow(2.0, rarity) * 5.0f + (float)((rarity - 1) * 5);
        int levelMult = level * enchantment.getMaxLevel() + 1;
        int treasureMult = holder.is(EnchantmentTags.TREASURE) ? 2 : 1;
        int curseMult = holder.is(EnchantmentTags.CURSE) ? 2 : 1;
        int discount = 1 + enchantability / Tiers.GOLD.getEnchantmentValue();
        return Math.round(rarityMult * (float)levelMult * (float)treasureMult * (float)curseMult / (float)discount);
    }

    @SafeVarargs
    public static Tuple<ItemStack, Integer> removeEnchantments(HolderLookup.Provider registryLookup, @NotNull ItemStack itemStack, ResourceKey<Enchantment> ... enchantmentKeys) {
        if (!EnchantmentHelper.hasAnyEnchantments((ItemStack)itemStack)) {
            return new Tuple((Object)itemStack, (Object)0);
        }
        HolderLookup.RegistryLookup wrapper = Ench.getRegistry(registryLookup).orElse(null);
        if (wrapper == null) {
            return new Tuple((Object)itemStack, (Object)0);
        }
        return Ench.removeEnchantments(itemStack, Arrays.stream(enchantmentKeys).map(key -> wrapper.get(key).orElse(null)).filter(Objects::nonNull).toList());
    }

    @SafeVarargs
    public static Tuple<ItemStack, Integer> removeEnchantments(@NotNull ItemStack itemStack, Holder<Enchantment> ... enchantments) {
        return Ench.removeEnchantments(itemStack, Arrays.stream(enchantments).toList());
    }

    public static <T extends Holder<Enchantment>> Tuple<ItemStack, Integer> removeEnchantments(@NotNull ItemStack itemStack, List<T> enchantments) {
        AtomicInteger removals = new AtomicInteger(0);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack));
        enchantments.forEach(enchantment -> {
            if (builder.keySet().contains(enchantment)) {
                builder.set(enchantment, 0);
                removals.getAndIncrement();
            }
        });
        ItemEnchantments component = builder.toImmutable();
        if (itemStack.is(Items.ENCHANTED_BOOK) && component.isEmpty()) {
            itemStack = new ItemStack((ItemLike)Items.BOOK, itemStack.getCount());
        }
        EnchantmentHelper.setEnchantments((ItemStack)itemStack, (ItemEnchantments)builder.toImmutable());
        return new Tuple((Object)itemStack, (Object)removals.get());
    }

    public static ItemStack getEnchantedStack(HolderLookup.Provider lookup, Item item, Map<ResourceKey<Enchantment>, Integer> enchantments) {
        HolderLookup.RegistryLookup wrapper = lookup.lookupOrThrow(Registries.ENCHANTMENT);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Map.Entry<ResourceKey<Enchantment>, Integer> e : enchantments.entrySet()) {
            builder.upgrade((Holder)wrapper.getOrThrow(e.getKey()), e.getValue().intValue());
        }
        ItemStack stack = item.getDefaultInstance();
        stack.set(DataComponents.ENCHANTMENTS, (Object)builder.toImmutable());
        return stack;
    }

    public static int getLevel(HolderLookup.Provider registryLookup, ResourceKey<Enchantment> enchantment, ItemStack stack) {
        return Ench.getRegistry(registryLookup).flatMap(impl -> impl.get(enchantment)).map(entry -> EnchantmentHelper.getItemEnchantmentLevel((Holder)entry, (ItemStack)stack)).orElse(0);
    }

    public static boolean hasEnchantment(HolderLookup.Provider registryLookup, ResourceKey<Enchantment> enchantment, ItemStack stack) {
        return Ench.getLevel(registryLookup, enchantment, stack) > 0;
    }

    public static Optional<HolderLookup.RegistryLookup<Enchantment>> getRegistry(HolderLookup.Provider registryLookup) {
        if (registryLookup == null) {
            return Optional.empty();
        }
        return registryLookup.lookup(Registries.ENCHANTMENT);
    }

    public static Optional<Holder<Enchantment>> getEntry(HolderLookup.Provider lookup, ResourceKey<Enchantment> key) {
        if (lookup == null) {
            return Optional.empty();
        }
        return Ench.getRegistry(lookup).flatMap(impl -> impl.get(key));
    }

    public static int getEquipmentLevel(HolderLookup.Provider lookup, ResourceKey<Enchantment> key, LivingEntity entity) {
        if (lookup == null) {
            return 0;
        }
        return Ench.getEntry(lookup, key).map(e -> EnchantmentHelper.getEnchantmentLevel((Holder)e, (LivingEntity)entity)).orElse(0);
    }
}

