/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.enchantments;

import earth.terrarium.pastel.mixin.accessors.MobEntityAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class DisarmingHelper {
    public static void disarmEntity(LivingEntity livingEntity) {
        if (livingEntity instanceof EnderMan) {
            Item item;
            EnderMan endermanEntity = (EnderMan)livingEntity;
            BlockState carriedBlockState = endermanEntity.getCarriedBlock();
            if (carriedBlockState != null && (item = carriedBlockState.getBlock().asItem()) != null) {
                endermanEntity.spawnAtLocation(item.getDefaultInstance());
                endermanEntity.setCarriedBlock(null);
            }
            return;
        }
        ArrayList<EquipmentSlot> slots = new ArrayList<EquipmentSlot>(List.of(EquipmentSlot.values()));
        Collections.shuffle(slots);
        for (EquipmentSlot slot : slots) {
            Mob mobEntity;
            ItemStack slotStack = livingEntity.getItemBySlot(slot);
            if (slotStack.isEmpty() || livingEntity instanceof Mob && ((MobEntityAccessor)(mobEntity = (Mob)livingEntity)).invokeGetEquipmentDropChance(slot) <= 0.0f) continue;
            livingEntity.spawnAtLocation(slotStack);
            livingEntity.setItemSlot(slot, ItemStack.EMPTY);
            livingEntity.level().playSound(null, livingEntity.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.NEUTRAL, 1.0f, 1.0f);
            break;
        }
    }
}

