/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.data;

import com.mojang.serialization.Codec;
import earth.terrarium.pastel.api.energy.color.InkColor;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.items.PigmentItem;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ColorHelper {
    public static final Codec<Integer> CODEC = Codec.withAlternative((Codec)Codec.INT, (Codec)Codec.STRING.comapFlatMap(CodecHelper.throwable(ColorHelper::fromString), ColorHelper::toString));
    public static List<DyeColor> VANILLA_DYE_COLORS = Arrays.stream(DyeColor.values()).filter(dyeColor -> dyeColor.getId() < 16).toList();
    public static final Vector3f WASH = new Vector3f(1.0f, 1.0f, 1.0f);
    private static final Pattern PARSE_PATTERN = Pattern.compile("#([0-9a-fA-F]{2})(?:([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})?)?");

    public static Vector3f getRGBVec(DyeColor dyeColor) {
        return InkColor.ofDyeColor(dyeColor).getColorVec();
    }

    public static int getInt(DyeColor dyeColor) {
        Vector3f vec = ColorHelper.getRGBVec(dyeColor);
        return new Color(vec.x(), vec.y(), vec.z()).getRGB() & 0xFFFFFF;
    }

    private int parseHex(String str) {
        return Integer.valueOf(str, 16);
    }

    public static int fromString(String color) throws NumberFormatException {
        Matcher m = PARSE_PATTERN.matcher(color);
        if (!m.matches()) {
            throw new NumberFormatException("Failed to parse the hex code '" + color + "'");
        }
        int c1 = Integer.parseInt(m.group(1), 16);
        int c2 = m.group(2) == null ? c1 : Integer.parseInt(m.group(2), 16);
        int c3 = m.group(3) == null ? c1 : Integer.parseInt(m.group(3), 16);
        int c4 = m.group(4) == null ? -1 : Integer.parseInt(m.group(4), 16);
        return FastColor.ARGB32.color((int)c4, (int)c1, (int)c2, (int)c3);
    }

    public static String toString(int color) {
        return String.format("#%X%X%X%X", FastColor.ARGB32.alpha((int)color), FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color));
    }

    public static int getRandomColor(int seed) {
        return Color.getHSBColor((float)seed / 2.1474836E9f, 0.7f, 0.9f).getRGB();
    }

    @NotNull
    public static Vector3f colorIntToVec(int color) {
        Color colorObj = new Color(color);
        float[] argb = new float[4];
        colorObj.getColorComponents(argb);
        return new Vector3f(argb[0], argb[1], argb[2]);
    }

    public static int colorVecToRGB(Vector3f color) {
        Color colorObj = new Color(color.x, color.y, color.z);
        return colorObj.getRGB();
    }

    public static Optional<DyeColor> getDyeColorOfItemStack(@NotNull ItemStack itemStack) {
        if (!itemStack.isEmpty()) {
            Item item = itemStack.getItem();
            if (item instanceof DyeItem) {
                DyeItem dyeItem = (DyeItem)item;
                return Optional.of(dyeItem.getDyeColor());
            }
            if (item instanceof PigmentItem) {
                PigmentItem pigmentItem = (PigmentItem)item;
                return pigmentItem.getInkColor().getDyeColor();
            }
        }
        return Optional.empty();
    }

    public static int interpolate(Vector3f start, Vector3f end, float delta) {
        int blendedRed = Math.round(Mth.lerp((float)delta, (float)start.x, (float)end.x) * 255.0f);
        int blendedGreen = Math.round(Mth.lerp((float)delta, (float)start.y, (float)end.y) * 255.0f);
        int blendedBlue = Math.round(Mth.lerp((float)delta, (float)start.z, (float)end.z) * 255.0f);
        return (blendedRed & 0xFF) << 16 | (blendedGreen & 0xFF) << 8 | blendedBlue & 0xFF | 0xFF000000;
    }
}

