/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.helpers.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.mixin.accessors.CachedRegistryInfoGetterAccessor;
import earth.terrarium.pastel.mixin.accessors.RegistryOpsAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.apache.commons.lang3.math.Fraction;

public class CodecHelper {
    public static Codec<Fraction> FRACTION = Codec.mapPair((MapCodec)Codec.INT.fieldOf("numerator"), (MapCodec)Codec.INT.fieldOf("denominator")).codec().xmap(pair -> Fraction.getFraction((int)((Integer)pair.getFirst()), (int)((Integer)pair.getSecond())), frac -> new Pair((Object)frac.getNumerator(), (Object)frac.getDenominator()));
    public static Codec<ResourceLocation> SPECTRUM_DEFAULTED_IDENTIFIER = Codec.STRING.xmap(PastelCommon::ofPastel, ResourceLocation::toString);
    public static MapCodec<HolderLookup.Provider> LOOKUP = new MapCodec<HolderLookup.Provider>(){

        public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
            return Stream.empty();
        }

        public <T> DataResult<HolderLookup.Provider> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
            if (dynamicOps instanceof RegistryOps) {
                RegistryOps registryOps = (RegistryOps)dynamicOps;
                RegistryOps.RegistryInfoLookup infoGetter = ((RegistryOpsAccessor)registryOps).getLookupProvider();
                HolderLookup.Provider lookup = ((CachedRegistryInfoGetterAccessor)infoGetter).getLookupProvider();
                return DataResult.success((Object)lookup);
            }
            return DataResult.error(() -> "The LOOKUP codec requires RegistryOps.");
        }

        public <T> RecordBuilder<T> encode(HolderLookup.Provider wrapperLookup, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
            return recordBuilder;
        }
    };

    public static <L, R> MapCodec<Tuple<L, R>> mapPair(MapCodec<L> leftCodec, MapCodec<R> rightCodec) {
        return RecordCodecBuilder.mapCodec(i -> i.group((App)leftCodec.forGetter(Tuple::getA), (App)rightCodec.forGetter(Tuple::getB)).apply((Applicative)i, Tuple::new));
    }

    public static <K, V> MapCodec<Map<K, V>> registryMap(final Registry<K> registry, final Codec<V> valueCodec) {
        final Codec keyCodec = registry.byNameCodec();
        return new MapCodec<Map<K, V>>(){

            public <T> Stream<T> keys(DynamicOps<T> dynamicOps) {
                return registry.keys(dynamicOps);
            }

            public <T> DataResult<Map<K, V>> decode(DynamicOps<T> dynamicOps, MapLike<T> mapLike) {
                return DataResult.success((Object)mapLike.entries().map(entry -> {
                    Object keyResult = keyCodec.decode(dynamicOps, entry.getFirst()).result().map(Pair::getFirst).orElse(null);
                    Object valueResult = valueCodec.decode(dynamicOps, entry.getSecond()).result().map(Pair::getFirst).orElse(null);
                    if (keyResult == null || valueResult == null) {
                        return null;
                    }
                    return new Tuple(keyResult, valueResult);
                }).filter(Objects::nonNull).collect(HashMap::new, (map, pair) -> map.put(pair.getA(), pair.getB()), HashMap::putAll));
            }

            public <T> RecordBuilder<T> encode(Map<K, V> kvMap, DynamicOps<T> dynamicOps, RecordBuilder<T> recordBuilder) {
                for (Map.Entry entry : kvMap.entrySet()) {
                    DataResult keyData = keyCodec.encodeStart(dynamicOps, entry.getKey());
                    DataResult valueData = valueCodec.encodeStart(dynamicOps, entry.getValue());
                    recordBuilder.add(keyData, valueData);
                }
                return recordBuilder;
            }
        };
    }

    public static <T> Codec<List<T>> singleOrList(Codec<T> codec) {
        return Codec.withAlternative((Codec)codec.listOf(), codec, List::of);
    }

    public static <I, O, E extends Throwable> Function<I, DataResult<O>> throwable(ThrowableFunction<I, O, E> throwable) {
        return input -> {
            try {
                return DataResult.success(throwable.apply(input));
            }
            catch (Throwable e) {
                return DataResult.error(e::getMessage);
            }
        };
    }

    public static <T, D> Optional<T> from(DynamicOps<D> ops, Codec<T> codec, D elem) {
        if (elem == null) {
            return Optional.empty();
        }
        return codec.decode(ops, elem).result().map(Pair::getFirst);
    }

    public static <T> Optional<T> fromNbt(Codec<T> codec, Tag nbt) {
        return CodecHelper.from(NbtOps.INSTANCE, codec, nbt);
    }

    public static <T> T fromNbt(Codec<T> codec, Tag nbt, T defaultValue) {
        return CodecHelper.fromNbt(codec, nbt).orElse(defaultValue);
    }

    public static <T> Optional<T> fromJson(Codec<T> codec, JsonElement json) {
        return CodecHelper.from(JsonOps.INSTANCE, codec, json);
    }

    public static <T> T fromJson(Codec<T> codec, JsonElement json, T defaultValue) {
        return CodecHelper.fromJson(codec, json).orElse(defaultValue);
    }

    public static <T> void toNbt(Codec<T> codec, T value, Consumer<? super Tag> ifValid) {
        codec.encodeStart((DynamicOps)NbtOps.INSTANCE, value).result().ifPresent(ifValid);
    }

    public static <T> void writeNbt(CompoundTag nbt, String key, Codec<T> codec, T value) {
        CodecHelper.toNbt(codec, value, elem -> nbt.put(key, elem));
    }

    public static interface ThrowableFunction<I, O, E extends Throwable> {
        public O apply(I var1) throws E;
    }
}

