/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.api.item.MergeableItem;
import earth.terrarium.pastel.api.item.SplittableItem;
import earth.terrarium.pastel.attachments.HardcoreDeathTracker;
import earth.terrarium.pastel.attachments.data.InertiaData;
import earth.terrarium.pastel.attachments.data.MiscPlayerData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeData;
import earth.terrarium.pastel.attachments.data.azure_dike.AzureDikeProvider;
import earth.terrarium.pastel.capabilities.ExperienceHandler;
import earth.terrarium.pastel.capabilities.PastelCapabilities;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.helpers.enchantments.ImprovedCriticalHelper;
import earth.terrarium.pastel.items.tools.NectarLanceItem;
import earth.terrarium.pastel.items.trinkets.PastelTrinketItem;
import earth.terrarium.pastel.items.trinkets.WhispyCircletItem;
import earth.terrarium.pastel.progression.PastelCriteria;
import earth.terrarium.pastel.registries.PastelEnchantments;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingSwapItemsEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class PastelPlayerEvents {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::canPlayerSleep);
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::playerWakeUp);
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::playerSleepEnd);
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::playerTick);
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::clonePlayer);
        NeoForge.EVENT_BUS.addListener(PastelPlayerEvents::handleSplitMerge);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGH, PastelPlayerEvents::forceCritical);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelPlayerEvents::applyImprovedCritical);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelPlayerEvents::postPlayerDeath);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelPlayerEvents::removeHardcoreDeath);
    }

    private static void absorbExperience(PlayerXpEvent.PickupXp event) {
        Player player = event.getEntity();
        ExperienceOrb orb = event.getOrb();
        for (ItemStack stack : player.getHandSlots()) {
            ExperienceHandler storage = (ExperienceHandler)stack.getCapability(PastelCapabilities.Misc.XP, (Object)player.registryAccess());
            if (storage == null) continue;
            storage.insert(orb.getValue(), false);
            orb.discard();
        }
    }

    private static void removeHardcoreDeath(PlayerEvent.PlayerChangeGameModeEvent event) {
        GameType curMode = event.getCurrentGameMode();
        GameType newMode = event.getNewGameMode();
        Player player = event.getEntity();
        if (newMode != GameType.SPECTATOR && curMode == GameType.SPECTATOR && HardcoreDeathTracker.hasHardcoreDeath(player.getGameProfile())) {
            HardcoreDeathTracker.removeHardcoreDeath(player.getGameProfile());
        }
    }

    private static void postPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof ServerPlayer && PastelTrinketItem.hasEquipped((LivingEntity)(player = (ServerPlayer)entity), (Item)PastelItems.JEOPARDANT.get())) {
            PastelCriteria.JEOPARDANT_KILL.trigger(player, (Entity)event.getEntity());
        }
        if ((entity = event.getEntity()) instanceof ServerPlayer && ((player = (ServerPlayer)entity).level().getLevelData().isHardcore() || HardcoreDeathTracker.isInHardcore((Player)player))) {
            HardcoreDeathTracker.addHardcoreDeath(player.serverLevel(), player);
        }
    }

    private static void applyImprovedCritical(CriticalHitEvent event) {
        Player player = event.getEntity();
        int icl = Ench.getLevel((HolderLookup.Provider)player.level().registryAccess(), PastelEnchantments.IMPROVED_CRITICAL, event.getEntity().getMainHandItem());
        event.setDamageMultiplier(event.getDamageMultiplier() + ImprovedCriticalHelper.getAddtionalCritDamageMultiplier(icl));
    }

    private static void forceCritical(CriticalHitEvent event) {
        Player player = event.getEntity();
        Entity target = event.getTarget();
        MiscPlayerData misc = MiscPlayerData.get(player);
        if (NectarLanceItem.sleepCrits(player, target) || misc.isParrying() || misc.isLunging()) {
            if (misc.isParrying()) {
                misc.setParryTicks(0);
            }
            if (misc.consumePerfectCounter()) {
                event.setDamageMultiplier(event.getDamageMultiplier() + 0.5f);
            }
            if (!event.isCriticalHit()) {
                event.setCriticalHit(true);
                event.setDamageMultiplier(event.getDamageMultiplier() + 0.5f);
            }
        }
    }

    private static void handleSplitMerge(LivingSwapItemsEvent.Hands event) {
        ItemStack mainHand = event.getItemSwappedToOffHand();
        ItemStack offHand = event.getItemSwappedToMainHand();
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        if (PastelPlayerEvents.trySplit(event, player, mainHand, offHand)) {
            return;
        }
        PastelPlayerEvents.tryMerge(event, player, mainHand, offHand);
    }

    /*
     * Unable to fully structure code
     */
    private static boolean trySplit(LivingSwapItemsEvent.Hands event, ServerPlayer player, ItemStack mainHand, ItemStack offHand) {
        offering = ItemStack.EMPTY;
        splittable = null;
        var8_6 = mainHand.getItem();
        if (!(var8_6 instanceof SplittableItem)) ** GOTO lbl-1000
        split = (SplittableItem)var8_6;
        if (offHand.isEmpty()) {
            offering = mainHand;
            splittable = split;
        } else if ((var8_6 = offHand.getItem()) instanceof SplittableItem) {
            split = (SplittableItem)var8_6;
            if (mainHand.isEmpty()) {
                offering = offHand;
                splittable = split;
            }
        }
        if (splittable != null) {
            if (!splittable.canSplit(player, player.getUsedItemHand(), offering)) {
                return false;
            }
            splitStack = splittable.getSplitResult(player, offering);
            event.setItemSwappedToMainHand(splitStack.copy());
            event.setItemSwappedToOffHand(splitStack.copy());
            return true;
        }
        return false;
    }

    private static void tryMerge(LivingSwapItemsEvent.Hands event, ServerPlayer player, ItemStack mainHand, ItemStack offHand) {
        ItemStack firstHalf = ItemStack.EMPTY;
        ItemStack secondHalf = ItemStack.EMPTY;
        MergeableItem mergeable = null;
        boolean off = false;
        Item item = mainHand.getItem();
        if (item instanceof MergeableItem) {
            MergeableItem merge = (MergeableItem)item;
            firstHalf = mainHand;
            secondHalf = offHand;
            mergeable = merge;
        } else {
            item = offHand.getItem();
            if (item instanceof MergeableItem) {
                MergeableItem merge = (MergeableItem)item;
                firstHalf = offHand;
                secondHalf = mainHand;
                off = true;
                mergeable = merge;
            }
        }
        if (mergeable == null || !mergeable.canMerge(player, firstHalf, secondHalf)) {
            return;
        }
        ItemStack mergeStack = mergeable.getMergeResult(player, firstHalf, secondHalf);
        if (!off) {
            event.setItemSwappedToMainHand(mergeStack);
            event.setItemSwappedToOffHand(ItemStack.EMPTY);
        } else {
            event.setItemSwappedToMainHand(ItemStack.EMPTY);
            event.setItemSwappedToOffHand(mergeStack);
        }
    }

    private static void playerWakeUp(PlayerWakeUpEvent event) {
        Player player = event.getEntity();
        MiscPlayerData.get(player).resetSleepingState(false);
        player.removeEffect(PastelMobEffects.SOMNOLENCE);
    }

    private static void playerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        MiscPlayerData.get(player).tick();
        InertiaData.tick(player);
    }

    private static void canPlayerSleep(CanPlayerSleepEvent event) {
        ServerPlayer player = event.getEntity();
        Player.BedSleepingProblem reason = event.getProblem();
        if (reason != Player.BedSleepingProblem.NOT_POSSIBLE_NOW && MiscPlayerData.get((Player)player).isSleeping()) {
            event.setProblem(null);
        } else if ((reason == Player.BedSleepingProblem.NOT_POSSIBLE_NOW || reason == Player.BedSleepingProblem.NOT_SAFE) && player.hasEffect(PastelMobEffects.SOMNOLENCE)) {
            event.setProblem(null);
        }
    }

    private static void playerSleepEnd(PlayerWakeUpEvent event) {
        ServerPlayer serverPlayerEntity;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (serverPlayerEntity = (ServerPlayer)player).getSleepTimer() == 100 && PastelTrinketItem.hasEquipped((LivingEntity)player, (Item)PastelItems.WHISPY_CIRCLET.get())) {
            player.setHealth(player.getMaxHealth());
            WhispyCircletItem.removeNegativeStatusEffects((LivingEntity)player);
        }
    }

    private static void clonePlayer(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        AzureDikeData newDike = event.isWasDeath() ? (AzureDikeData)AzureDikeData.CLONER.copy((Object)AzureDikeProvider.getAzureDikeComponent((LivingEntity)original), (IAttachmentHolder)original, (HolderLookup.Provider)original.registryAccess()) : AzureDikeProvider.getAzureDikeComponent((LivingEntity)original);
        event.getEntity().setData(AzureDikeData.ATTACHMENT, (Object)newDike);
    }
}

