/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.events;

import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.level.MobEffectHelper;
import earth.terrarium.pastel.injectors.MobEffectInstanceInjector;
import earth.terrarium.pastel.items.trinkets.AetherGracedNectarGlovesItem;
import earth.terrarium.pastel.registries.PastelDamageTypes;
import earth.terrarium.pastel.registries.PastelMobEffectTags;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.status_effects.SleepStatusEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

public class PastelEffectEvents {
    static final Map<UUID, List<MobEffectInstance>> QUEUED_ADDITIONS = new HashMap<UUID, List<MobEffectInstance>>();

    public static void register(IEventBus pastelBus) {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, PastelEffectEvents::sleepDurationModifications);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, PastelEffectEvents::fatalSlumberKill);
        NeoForge.EVENT_BUS.addListener(PastelEffectEvents::actionIncurable);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOW, PastelEffectEvents::applyEffectImmunity);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEffectEvents::convertSleepEffects);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, PastelEffectEvents::applyNectarGlovesImmunity);
    }

    private static void fatalSlumberKill(MobEffectEvent.Expired event) {
        MobEffectInstance effect = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        Level level = entity.level();
        boolean player = entity instanceof Player;
        if (event.getEffectInstance() == null || !effect.getEffect().equals(PastelMobEffects.FATAL_SLUMBER) || level.isClientSide()) {
            return;
        }
        if (entity.isSpectator() || player && ((Player)entity).isCreative()) {
            return;
        }
        float damage = 7.777778E8f;
        if (SleepStatusEffect.isResistedBy(entity)) {
            damage = entity.getType().is(Tags.EntityTypes.BOSSES) ? entity.getHealth() * 0.34f : entity.getHealth() * 0.95f;
        }
        entity.hurt(PastelDamageTypes.sleep(level, null), damage);
        if (entity.isAlive() && entity instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            Support.grantAdvancementCriterion(sPlayer, "lategame/survive_fatal_slumber", "survived_fatal_slumber");
        }
    }

    private static void actionIncurable(MobEffectEvent.Remove event) {
        MobEffectInstance removed = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        EffectCure cure = event.getCure();
        if (removed == null || !MobEffectHelper.resistsRemoval(removed)) {
            return;
        }
        if (cure.equals(PastelMobEffects.Cures.SEDATIVES)) {
            return;
        }
        PastelMobEffects.cutDuration(entity, removed);
        event.setCanceled(true);
    }

    private static void convertSleepEffects(MobEffectEvent.Remove event) {
        MobEffectInstance removed = event.getEffectInstance();
        UUID id = event.getEntity().getUUID();
        if (removed == null) {
            return;
        }
        if (removed.getEffect().equals(PastelMobEffects.FATAL_SLUMBER)) {
            QUEUED_ADDITIONS.computeIfAbsent(id, i -> new ArrayList()).add(new MobEffectInstance(PastelMobEffects.ETERNAL_SLUMBER, 6000));
            return;
        }
        if (!PastelMobEffects.Cures.SEDATIVES.equals(event.getCure())) {
            return;
        }
        if (removed.getEffect().equals(PastelMobEffects.SOMNOLENCE)) {
            QUEUED_ADDITIONS.computeIfAbsent(id, i -> new ArrayList()).add(new MobEffectInstance(PastelMobEffects.ETERNAL_SLUMBER, removed.getDuration()));
        } else if (removed.getEffect().equals(PastelMobEffects.CALMING)) {
            QUEUED_ADDITIONS.computeIfAbsent(id, i -> new ArrayList()).add(new MobEffectInstance(PastelMobEffects.SOMNOLENCE, removed.getDuration()));
        }
    }

    private static void applyEffectImmunity(MobEffectEvent.Applicable event) {
        if (!event.getApplicationResult()) {
            return;
        }
        MobEffectInstance proposal = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        MobEffectInstance immunity = entity.getEffect(PastelMobEffects.IMMUNITY);
        if (immunity == null || proposal.getEffect().is(PastelMobEffectTags.BYPASSES_IMMUNITY)) {
            return;
        }
        if (!MobEffectHelper.resistsRemoval(proposal)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
            return;
        }
        if (MobEffectHelper.drainImmunity(immunity, proposal.getAmplifier() + 1)) {
            entity.removeEffect(PastelMobEffects.IMMUNITY);
        }
        event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        PastelEffectEvents.updateEffectInClient(entity, immunity);
    }

    private static void applyNectarGlovesImmunity(MobEffectEvent.Applicable event) {
        MobEffectInstance proposal = event.getEffectInstance();
        LivingEntity entity = event.getEntity();
        if (!event.getApplicationResult() || !AetherGracedNectarGlovesItem.testEffectFor(entity, (Holder<MobEffect>)proposal.getEffect())) {
            return;
        }
        int cost = (proposal.getAmplifier() + 1) * 5;
        if (MobEffectHelper.resistsRemoval(proposal)) {
            cost *= 2;
        }
        if (AetherGracedNectarGlovesItem.tryBlockEffect(entity, cost)) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    private static void sleepDurationModifications(MobEffectEvent.Added event) {
        MobEffectInstance effect = event.getEffectInstance();
        MobEffectInstanceInjector modifiable = (MobEffectInstanceInjector)effect;
        LivingEntity entity = event.getEntity();
        boolean resistant = SleepStatusEffect.isResistedBy(entity);
        float sleepResist = Mth.clamp((float)SleepStatusEffect.getSleepResistance(effect, entity), (float)0.1f, (float)10.0f);
        boolean actioned = false;
        if (effect.getEffect().equals(PastelMobEffects.ETERNAL_SLUMBER)) {
            PastelEffectEvents.sleepEternal(resistant, modifiable, effect, sleepResist);
            actioned = true;
        } else if (effect.getEffect().equals(PastelMobEffects.FATAL_SLUMBER)) {
            PastelEffectEvents.sleepFatal(resistant && entity.getType().is(Tags.EntityTypes.BOSSES), modifiable, effect, sleepResist);
            actioned = true;
        }
        if (actioned) {
            PastelEffectEvents.updateEffectInClient(entity, effect);
        }
    }

    private static void sleepEternal(boolean resistant, MobEffectInstanceInjector modifiable, MobEffectInstance effect, float sleepResist) {
        if (resistant) {
            modifiable.setDuration(Math.round((float)effect.getDuration() / sleepResist));
        } else {
            modifiable.setDuration(-1);
        }
    }

    private static void sleepFatal(boolean applicableBoss, MobEffectInstanceInjector modifiable, MobEffectInstance effect, float sleepResist) {
        if (applicableBoss) {
            modifiable.setDuration(2400);
        } else {
            modifiable.setDuration(Math.max(200, Math.round((float)effect.getDuration() * sleepResist * 3.0f)));
        }
    }

    private static void updateEffectInClient(LivingEntity entity, MobEffectInstance effect) {
        if (!entity.level().isClientSide()) {
            ((ServerLevel)entity.level()).getChunkSource().broadcastAndSend((Entity)entity, (Packet)new ClientboundUpdateMobEffectPacket(entity.getId(), effect, false));
        }
    }
}

