/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.spawners;

import com.cmdpro.databank.DatabankUtils;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.blocks.shooting_star.ShootingStar;
import earth.terrarium.pastel.entity.entity.ShootingStarEntity;
import earth.terrarium.pastel.registries.PastelAdvancements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.NotNull;

public class ShootingStarSpawner
implements CustomSpawner {
    public static final ShootingStarSpawner INSTANCE = new ShootingStarSpawner();

    private ShootingStarSpawner() {
    }

    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        int spawns = 0;
        for (Player playerEntity : world.getEntities((EntityTypeTest)EntityType.PLAYER, Entity::isAlive)) {
            if (playerEntity.isSpectator() || !DatabankUtils.hasAdvancement((Player)playerEntity, (ResourceLocation)PastelAdvancements.UNLOCK_SHOOTING_STARS) || !(world.getRandom().nextFloat() < ShootingStarSpawner.getShootingStarChanceWithMultiplier(playerEntity))) continue;
            if (world.getRandom().nextFloat() < 0.01f) {
                for (int i = 0; i < 5; ++i) {
                    ShootingStarSpawner.spawnShootingStar(world, playerEntity);
                }
                spawns += 5;
                continue;
            }
            ShootingStarSpawner.spawnShootingStar(world, playerEntity);
            ++spawns;
        }
        return spawns;
    }

    protected static float getShootingStarChanceWithMultiplier(@NotNull Player playerEntity) {
        int multiplier = 1;
        for (ItemStack handStack : playerEntity.getHandSlots()) {
            if (handStack == null || !handStack.is(Items.SPYGLASS)) continue;
            multiplier += 4;
            break;
        }
        if (playerEntity.hasEffect(MobEffects.NIGHT_VISION)) {
            ++multiplier;
        }
        return PastelCommon.CONFIG.ShootingStarChance * (float)multiplier;
    }

    public static void spawnShootingStar(ServerLevel serverWorld, @NotNull Player playerEntity) {
        ShootingStarEntity shootingStarEntity = new ShootingStarEntity((Level)serverWorld, playerEntity.position().x(), playerEntity.position().y() + 200.0, playerEntity.position().z(), ShootingStar.Variant.getWeightedRandomType(serverWorld.getRandom()), false, 3 + serverWorld.random.nextInt(5), false);
        shootingStarEntity.setDeltaMovement(serverWorld.random.nextDouble() * 0.2 - 0.1, 0.0, serverWorld.random.nextDouble() * 0.2 - 0.1);
        shootingStarEntity.push(5.0f - serverWorld.random.nextFloat() * 10.0f, 0.0, 5.0f - serverWorld.random.nextFloat() * 10.0f);
        serverWorld.addFreshEntity((Entity)shootingStarEntity);
    }
}

