/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.pastel.entity.entity.LightMineEntity;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class LightMineEntityRenderer
extends EntityRenderer<LightMineEntity> {
    public LightMineEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(LightMineEntity mine, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.pushPose();
        int age = mine.tickCount;
        float alpha = Mth.clamp((float)(1.0f - Mth.lerp((float)tickDelta, (float)mine.getVanishingProgress(age - 1), (float)mine.getVanishingProgress(age))), (float)0.0f, (float)1.0f);
        float scaleFactor = Mth.sin((float)(((float)age + tickDelta) / 8.0f)) / 6.0f + mine.getScaleOffset();
        matrices.mulPose(this.entityRenderDispatcher.cameraOrientation());
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrices.scale(scaleFactor, scaleFactor, 1.0f);
        matrices.translate(-0.5f, -0.5f, 0.0f);
        VertexConsumer consumer = vertexConsumers.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)this.getTextureLocation(mine)));
        PoseStack.Pose matrix = matrices.last();
        Matrix4f positions = matrix.pose();
        Vector3f color = ColorHelper.colorIntToVec(mine.getColor());
        consumer.addVertex(positions, 0.0f, 0.0f, 0.0f).setColor(color.x(), color.y(), color.z(), alpha).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 1.0f, 0.0f, 0.0f).setColor(color.x(), color.y(), color.z(), alpha).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 1.0f, 1.0f, 0.0f).setColor(color.x(), color.y(), color.z(), alpha).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(positions, 0.0f, 1.0f, 0.0f).setColor(color.x(), color.y(), color.z(), alpha).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(matrix, 0.0f, 1.0f, 0.0f);
        matrices.popPose();
        super.render((Entity)mine, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public ResourceLocation getTextureLocation(LightMineEntity entity) {
        return entity.getTextureLocation();
    }
}

