/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import earth.terrarium.pastel.entity.entity.FloatBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FloatBlockEntityRenderer
extends EntityRenderer<FloatBlockEntity> {
    private final RandomSource random = RandomSource.create();

    public FloatBlockEntityRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
        this.shadowRadius = 0.5f;
    }

    public void render(FloatBlockEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        Level world;
        BlockState blockState = entity.getBlockState();
        if (blockState.getRenderShape() == RenderShape.MODEL && blockState != (world = entity.level()).getBlockState(BlockPos.containing((Position)entity.position())) && blockState.getRenderShape() != RenderShape.INVISIBLE) {
            matrices.pushPose();
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            matrices.translate(-0.5, 0.0, -0.5);
            BlockRenderDispatcher blockRenderManager = Minecraft.getInstance().getBlockRenderer();
            blockRenderManager.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, blockRenderManager.getBlockModel(blockState), blockState, blockpos, matrices, vertexConsumers.getBuffer(ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)blockState)), false, this.random, blockState.getSeed(entity.getOrigin()), OverlayTexture.NO_OVERLAY);
            matrices.popPose();
            super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public ResourceLocation getTextureLocation(FloatBlockEntity entityIn) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

