/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import earth.terrarium.pastel.entity.entity.EggLayingWoolyPigEntity;
import earth.terrarium.pastel.entity.models.EggLayingWoolyPigEntityModel;
import earth.terrarium.pastel.entity.models.EggLayingWoolyPigHatEntityModel;
import earth.terrarium.pastel.entity.models.EggLayingWoolyPigWoolEntityModel;
import earth.terrarium.pastel.entity.render.EggLayingWoolyPigEntityRenderer;
import earth.terrarium.pastel.registries.client.PastelModelLayers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class EggLayingWoolyPigWoolFeatureRenderer
extends RenderLayer<EggLayingWoolyPigEntity, EggLayingWoolyPigEntityModel> {
    private final EggLayingWoolyPigHatEntityModel hat;
    private final EggLayingWoolyPigWoolEntityModel wool;

    public EggLayingWoolyPigWoolFeatureRenderer(EggLayingWoolyPigEntityRenderer context, EntityModelSet loader) {
        super((RenderLayerParent)context);
        this.hat = new EggLayingWoolyPigHatEntityModel(loader.bakeLayer(PastelModelLayers.WOOLY_PIG_HAT));
        this.wool = new EggLayingWoolyPigWoolEntityModel(loader.bakeLayer(PastelModelLayers.WOOLY_PIG_WOOL));
    }

    public void render(PoseStack poseStack, MultiBufferSource vertexConsumerProvider, int i, EggLayingWoolyPigEntity entity, float f, float g, float h, float j, float k, float l) {
        if (entity.isInvisible()) {
            Minecraft minecraftClient = Minecraft.getInstance();
            boolean hasOutline = minecraftClient.shouldEntityAppearGlowing((Entity)entity);
            if (hasOutline) {
                int rgbColor = EggLayingWoolyPigEntity.getRgbColor(entity.getColor());
                VertexConsumer vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.outline((ResourceLocation)EggLayingWoolyPigEntityRenderer.TEXTURE));
                if (!entity.isHatless()) {
                    ((EggLayingWoolyPigEntityModel)this.getParentModel()).copyPropertiesTo(this.hat);
                    this.hat.prepareMobModel(entity, f, g, h);
                    this.hat.setupAnim(entity, f, g, j, k, l);
                    this.hat.renderToBuffer(poseStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), rgbColor);
                }
                if (!entity.isSheared()) {
                    ((EggLayingWoolyPigEntityModel)this.getParentModel()).copyPropertiesTo(this.wool);
                    this.wool.prepareMobModel((Entity)entity, f, g, h);
                    this.wool.setupAnim(entity, f, g, j, k, l);
                    this.wool.renderToBuffer(poseStack, vertexConsumer, i, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f), rgbColor);
                }
            }
        } else {
            int rgbColor = EggLayingWoolyPigEntity.getRgbColor(entity.getColor());
            if (!entity.isHatless()) {
                ((EggLayingWoolyPigEntityModel)this.getParentModel()).copyPropertiesTo(this.hat);
                this.hat.prepareMobModel(entity, f, g, h);
                this.hat.setupAnim(entity, f, g, j, k, l);
                EggLayingWoolyPigWoolFeatureRenderer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), (EntityModel)this.hat, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)poseStack, (MultiBufferSource)vertexConsumerProvider, (int)i, (LivingEntity)entity, (float)f, (float)g, (float)j, (float)k, (float)l, (float)h, (int)rgbColor);
            }
            if (!entity.isSheared()) {
                EggLayingWoolyPigWoolFeatureRenderer.coloredCutoutModelCopyLayerRender((EntityModel)this.getParentModel(), (EntityModel)this.wool, (ResourceLocation)this.getTextureLocation(entity), (PoseStack)poseStack, (MultiBufferSource)vertexConsumerProvider, (int)i, (LivingEntity)entity, (float)f, (float)g, (float)j, (float)k, (float)l, (float)h, (int)rgbColor);
            }
        }
    }

    public ResourceLocation getTextureLocation(EggLayingWoolyPigEntity entity) {
        return EggLayingWoolyPigEntityRenderer.TEXTURE;
    }
}

