/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.entity.PastelEntitySubPredicateTypes;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ShulkerPredicate(Optional<DyeColor> color) implements EntitySubPredicate
{
    public static final MapCodec<ShulkerPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.optionalFieldOf("color").forGetter(ShulkerPredicate::color)).apply((Applicative)instance, ShulkerPredicate::new));

    public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
        if (!(entity instanceof Shulker)) {
            return false;
        }
        Shulker shulkerEntity = (Shulker)entity;
        return this.color.isEmpty() || this.color.get() == shulkerEntity.getColor();
    }

    public MapCodec<ShulkerPredicate> codec() {
        return PastelEntitySubPredicateTypes.SHULKER;
    }
}

