/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import earth.terrarium.pastel.entity.PastelEntitySubPredicateTypes;
import earth.terrarium.pastel.entity.entity.KindlingEntity;
import earth.terrarium.pastel.entity.variants.KindlingVariant;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record KindlingPredicate(Optional<Boolean> clipped, Optional<Boolean> angry, Optional<KindlingVariant> variant) implements EntitySubPredicate
{
    public static final MapCodec<KindlingPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("clipped").forGetter(KindlingPredicate::clipped), (App)Codec.BOOL.optionalFieldOf("angry").forGetter(KindlingPredicate::angry), (App)KindlingVariant.CODEC.optionalFieldOf("variant").forGetter(KindlingPredicate::variant)).apply((Applicative)instance, KindlingPredicate::new));

    public boolean matches(Entity entity, ServerLevel world, @Nullable Vec3 pos) {
        if (!(entity instanceof KindlingEntity)) {
            return false;
        }
        KindlingEntity kindling = (KindlingEntity)entity;
        return !(!this.clipped.isEmpty() && this.clipped.get().booleanValue() != kindling.isClipped() || !this.angry.isEmpty() && (this.angry.get() != (kindling.getRemainingPersistentAngerTime() == 0) || !this.variant.isEmpty() && this.variant.get() != kindling.getKindlingVariant()));
    }

    public MapCodec<KindlingPredicate> codec() {
        return PastelEntitySubPredicateTypes.KINDLING;
    }
}

