/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.entity.PastelEntityTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeatEntity
extends Entity {
    private static final EntityDataAccessor<Integer> EMPTY_TICKS = SynchedEntityData.defineId(SeatEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<BlockState>> CUSHION = SynchedEntityData.defineId(SeatEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    private double offset = 0.0;

    public SeatEntity(EntityType<?> type, Level world) {
        super(type, world);
    }

    public SeatEntity(Level world, double offset) {
        super((EntityType)PastelEntityTypes.SEAT.get(), world);
        this.offset = offset;
    }

    public void tick() {
        super.tick();
        Block block = this.level().getBlockState(this.blockPosition()).getBlock();
        Optional<BlockState> cushion = this.getCushion();
        if (cushion.isEmpty()) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
            return;
        }
        BlockState state = cushion.get();
        if (!state.is(block)) {
            Iterable iter = BlockPos.withinManhattan((BlockPos)this.blockPosition(), (int)1, (int)1, (int)1);
            boolean fail = true;
            for (BlockPos pos : iter) {
                Block check = this.level().getBlockState(pos).getBlock();
                if (!state.is(check)) continue;
                this.absMoveTo((double)pos.getX() + 0.5, (double)pos.getY() + this.offset, (double)pos.getZ() + 0.5);
                fail = false;
                break;
            }
            if (fail) {
                this.incrementEmptyTicks();
            }
        }
        if (this.getFirstPassenger() == null) {
            this.incrementEmptyTicks();
        } else if (state.is(block)) {
            this.setEmptyTicks(0);
        }
        if (this.getEmptyTicks() > 10) {
            this.setRemoved(Entity.RemovalReason.DISCARDED);
        }
    }

    public Optional<BlockState> getCushion() {
        return (Optional)this.entityData.get(CUSHION);
    }

    public void setCushion(@NotNull BlockState state) {
        this.entityData.set(CUSHION, Optional.of(state));
    }

    public void setEmptyTicks(int ticks) {
        this.entityData.set(EMPTY_TICKS, (Object)ticks);
    }

    public int getEmptyTicks() {
        return (Integer)this.entityData.get(EMPTY_TICKS);
    }

    public void incrementEmptyTicks() {
        this.setEmptyTicks(this.getEmptyTicks() + 1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(EMPTY_TICKS, (Object)0);
        builder.define(CUSHION, Optional.empty());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.setEmptyTicks(nbt.getInt("emptyTicks"));
        BlockState state = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)nbt.getCompound("BlockState"));
        this.entityData.set(CUSHION, Optional.ofNullable(state.isAir() ? null : state));
        this.offset = nbt.getDouble("offset");
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putInt("emptyTicks", this.getEmptyTicks());
        nbt.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)((Optional)this.entityData.get(CUSHION)).orElse(Blocks.AIR.defaultBlockState())));
        nbt.putDouble("offset", this.offset);
    }

    public boolean isInvulnerable() {
        return true;
    }

    public void push(Entity entity) {
    }

    public void move(MoverType movementType, Vec3 movement) {
        if (movementType != MoverType.PISTON) {
            return;
        }
        super.move(movementType, movement);
    }

    @Nullable
    private Vec3 locateSafeDismountingPos(Vec3 offset, LivingEntity passenger) {
        double x = this.getX() + offset.x;
        double y = this.getBoundingBox().minY + 0.5;
        double z = this.getZ() + offset.z;
        BlockPos.MutableBlockPos testPos = new BlockPos.MutableBlockPos();
        block0: for (Pose pose : passenger.getDismountPoses()) {
            testPos.set(x, y, z);
            double maxHeight = this.getBoundingBox().maxY + 0.75;
            do {
                double height = this.level().getBlockFloorHeight((BlockPos)testPos);
                if ((double)testPos.getY() + height > maxHeight) continue block0;
                if (DismountHelper.isBlockFloorValid((double)height)) {
                    AABB boundingBox = passenger.getLocalBoundsForPose(pose);
                    Vec3 pos = new Vec3(x, (double)testPos.getY() + height, z);
                    if (DismountHelper.canDismountTo((CollisionGetter)this.level(), (LivingEntity)passenger, (AABB)boundingBox.move(pos))) {
                        passenger.setPose(pose);
                        return pos;
                    }
                }
                testPos.move(Direction.UP);
            } while (!((double)testPos.getY() >= maxHeight));
        }
        return null;
    }

    public void teleportTo(double destX, double destY, double destZ) {
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 vec3d = SeatEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 vec3d2 = this.locateSafeDismountingPos(vec3d, passenger);
        if (vec3d2 != null) {
            return vec3d2;
        }
        Vec3 vec3d3 = SeatEntity.getCollisionHorizontalEscapeVector((double)this.getBbWidth(), (double)passenger.getBbWidth(), (float)(this.getYRot() + (passenger.getMainArm() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 vec3d4 = this.locateSafeDismountingPos(vec3d3, passenger);
        return vec3d4 != null ? vec3d4 : this.position();
    }
}

