/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.interaction.projectile_behavior.ItemProjectileBehavior;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ItemProjectileEntity
extends ThrowableItemProjectile {
    public ItemProjectileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public ItemProjectileEntity(Level world, LivingEntity owner) {
        super((EntityType)PastelEntityTypes.ITEM_PROJECTILE.get(), owner, world);
    }

    protected void onHit(HitResult hitResult) {
        ItemStack stack = this.getItem();
        if (!this.level().isClientSide) {
            Player player;
            Entity owner;
            ItemProjectileBehavior behavior = ItemProjectileBehavior.get(stack);
            if (behavior != null) {
                HitResult.Type type = hitResult.getType();
                if (type == HitResult.Type.ENTITY) {
                    this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, hitResult.getLocation(), GameEvent.Context.of((Entity)this, null));
                    behavior.onEntityHit(this, stack, this.getOwner(), (EntityHitResult)hitResult);
                } else if (type == HitResult.Type.BLOCK) {
                    BlockHitResult blockHitResult = (BlockHitResult)hitResult;
                    BlockPos blockPos = blockHitResult.getBlockPos();
                    this.level().gameEvent((Holder)GameEvent.PROJECTILE_LAND, blockPos, GameEvent.Context.of((Entity)this, (BlockState)this.level().getBlockState(blockPos)));
                    stack = behavior.onBlockHit(this, stack, this.getOwner(), (BlockHitResult)hitResult);
                }
            }
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            if (!(stack.isEmpty() || (owner = this.getOwner()) instanceof Player && (player = (Player)owner).isCreative())) {
                Containers.dropItemStack((Level)this.level(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), (ItemStack)stack);
            }
            this.discard();
        }
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            ItemStack itemStack = this.getItem();
            SimpleParticleType particleEffect = itemStack.isEmpty() ? ParticleTypes.ITEM_SNOWBALL : new ItemParticleOption(ParticleTypes.ITEM, itemStack);
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)particleEffect, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected Item getDefaultItem() {
        return Items.AIR;
    }
}

