/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailLeftoverHandler;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.entity.PastelTrackedDataHandlerRegistry;
import earth.terrarium.pastel.helpers.Support;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.items.tools.GlassArrowVariant;
import earth.terrarium.pastel.registries.PastelRegistries;
import earth.terrarium.pastel.registries.PastelSounds;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;

public class GlassArrowEntity
extends AbstractArrow {
    private static final String VARIANT_STRING = "variant";
    public static final float DAMAGE_MODIFIER = 1.5f;
    private static final EntityDataAccessor<GlassArrowVariant> VARIANT = SynchedEntityData.defineId(GlassArrowEntity.class, PastelTrackedDataHandlerRegistry.GLASS_ARROW_VARIANT);
    private final IntOpenHashSet pierced = new IntOpenHashSet();
    private Optional<Entity> homingTarget = Optional.empty();
    private boolean laterHits = false;
    private boolean shouldRenderTrail = true;
    private TrailRender trail;

    public GlassArrowEntity(EntityType<? extends GlassArrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    public GlassArrowEntity(Level world, LivingEntity owner, ItemStack stack, ItemStack shotFrom) {
        super((EntityType)PastelEntityTypes.GLASS_ARROW.get(), owner, world, stack, shotFrom);
    }

    public GlassArrowEntity(Level world, double x, double y, double z, ItemStack stack, ItemStack shotFrom) {
        super((EntityType)PastelEntityTypes.GLASS_ARROW.get(), x, y, z, world, stack, shotFrom);
    }

    public void tick() {
        if (this.tickCount == 1 && this.getOwner() != null) {
            float volMod = (float)(Math.clamp(this.getDeltaMovement().length() / 6.0, 0.0, 0.75) + 0.325);
            float pitch = Support.varFloatCentered(this.random, 0.175f) + 0.2f;
            this.level().playSound(null, (Entity)this, PastelSounds.PIERCING_RADIANCE, SoundSource.PLAYERS, Support.varFloatCentered(this.random, 0.1f) * volMod, pitch);
            this.getOwner().playSound(PastelSounds.CAST_RADIANCE, 0.7f, pitch);
        }
        if (this.getVariant().getAttributes().homing()) {
            this.updateHomingTarget();
            this.tryHome();
        }
        Vec3 backtrack = this.getDeltaMovement().reverse();
        super.tick();
        if (this.tickCount > 300 || this.inGroundTime >= 20) {
            this.playSound(SoundEvents.GLASS_BREAK, 0.75f, 0.9f + this.getRandom().nextFloat() * 0.2f);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        if (this.isFirstHit()) {
            return;
        }
        this.handlePiercing(backtrack);
    }

    public int getInGroundTime() {
        return this.inGroundTime;
    }

    private void tryHome() {
        if (this.homingTarget.isPresent()) {
            Entity target = this.homingTarget.get();
            double vel = Math.min(this.getDeltaMovement().length() * 1.5, 3.0);
            Vec3 homeVector = target.position().add(0.0, (double)target.getEyeHeight() * 0.75, 0.0).subtract(this.position()).normalize();
            Vec3 curVector = this.getDeltaMovement().normalize();
            Vec3 finalVector = curVector.scale(0.6).add(homeVector.scale(0.4)).scale(vel);
            this.setDeltaMovement(finalVector);
        }
    }

    private void updateHomingTarget() {
        if (this.homingTarget.isPresent()) {
            if (!this.homingTarget.get().isAlive()) {
                this.homingTarget = Optional.empty();
            } else {
                return;
            }
        }
        AABB vision = this.getBoundingBox().expandTowards(this.getDeltaMovement().scale(5.0)).inflate(9.0);
        this.homingTarget = this.level().getEntities((Entity)this, vision, this::canHomeTowards).stream().reduce((a, b) -> this.distanceTo((Entity)a) <= this.distanceTo((Entity)b) ? a : b);
    }

    private void handlePiercing(Vec3 backtrack) {
        for (Entity proposal : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(backtrack).inflate(1.0), this::canHitEntity)) {
            EntityHitResult hit;
            AABB bounds = proposal.getBoundingBox().inflate((double)0.3f);
            if (!bounds.clip(this.position(), this.position().add(backtrack)).isPresent() || EventHooks.onProjectileImpact((Projectile)this, (HitResult)(hit = new EntityHitResult(proposal)))) continue;
            this.onHit((HitResult)hit);
        }
    }

    protected double getDefaultGravity() {
        if (this.getDeltaMovement().multiply(1.0, 0.0, 1.0).length() < 0.125) {
            return super.getDefaultGravity() / 3.0;
        }
        return 0.0;
    }

    public boolean isFirstHit() {
        return !this.laterHits;
    }

    protected boolean canHitEntity(Entity target) {
        return !this.pierced.contains(target.getId()) && super.canHitEntity(target);
    }

    protected boolean canHomeTowards(Entity target) {
        if (target == this.getOwner()) {
            return false;
        }
        return target.getType().getCategory() == MobCategory.MONSTER && this.canHitEntity(target);
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return PastelSounds.SHATTER_LIGHT;
    }

    protected void onHitEntity(EntityHitResult hit) {
        Level level = this.level();
        Entity target = hit.getEntity();
        GlassArrowVariant.Attributes attributes = this.getVariant().getAttributes();
        float damage = (float)((double)attributes.damage() * this.getBaseDamage() * 1.5);
        Entity owner = this.getOwner();
        DamageSource source = this.damageSources().source(attributes.type(), owner);
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            damage = EnchantmentHelper.modifyDamage((ServerLevel)sl, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)source, (float)damage);
        }
        if (this.getWeaponItem() != null) {
            damage *= 1.0f + (float)Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.POWER, this.getWeaponItem()) * 0.5f;
        }
        damage = Support.refineDamage((float)((double)damage * this.getDeltaMovement().length()));
        if (owner instanceof LivingEntity) {
            LivingEntity lvo = (LivingEntity)owner;
            lvo.setLastHurtMob(target);
        }
        boolean discard = false;
        if (target.hurt(source, damage)) {
            this.postHurt(target, source);
            discard = true;
        }
        if (!attributes.piercing()) {
            this.deflect(ProjectileDeflection.REVERSE, target, this.getOwner(), false);
            this.setDeltaMovement(this.getDeltaMovement().normalize().scale(0.1));
        }
        this.postHit((HitResult)hit);
        if (discard && this.getVariant().getAttributes().homing()) {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void postHurt(Entity entity, DamageSource source) {
        Entity owner = this.getOwner();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        this.doKnockback(target, source);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)sl, (Entity)target, (DamageSource)source, (ItemStack)this.getWeaponItem());
        }
        this.doPostHurtEffects(target);
        if (target instanceof Player && owner instanceof ServerPlayer && !this.isSilent()) {
            ((ServerPlayer)owner).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
        }
        if (this.getVariant().getAttributes().piercing()) {
            this.pierced.add(target.getId());
        }
        this.playSound(this.getDefaultHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        if (this.activelyHoming()) {
            return;
        }
        super.onHitBlock(blockHitResult);
        this.postHit((HitResult)blockHitResult);
    }

    public boolean activelyHoming() {
        return this.getVariant().getAttributes().homing() && this.homingTarget.isPresent();
    }

    private void postHit(HitResult hit) {
        this.getVariant().getAttributes().postHit().accept((Object)this, (Object)hit, (Object)this.level());
        this.laterHits = true;
    }

    public static void pull(Entity puller, Entity pulled, double pullStrength) {
        double d = puller.getX() - pulled.getX();
        double e = puller.getY() - pulled.getY();
        double f = puller.getZ() - pulled.getZ();
        double pullStrengthModifier = 1.0;
        if (pulled instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pulled;
            pullStrengthModifier = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
        }
        Vec3 additionalVelocity = new Vec3(d * pullStrength, e * pullStrength + Math.sqrt(Math.sqrt(d * d + e * e + f * f)) * 0.08, f * pullStrength).scale(pullStrengthModifier);
        pulled.push(additionalVelocity.x, additionalVelocity.y, additionalVelocity.z);
    }

    protected ItemStack getDefaultPickupItem() {
        return this.getVariant().getArrow().getDefaultInstance();
    }

    protected float getWaterInertia() {
        return 1.0f;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)GlassArrowVariant.MALACHITE);
    }

    public GlassArrowVariant getVariant() {
        return (GlassArrowVariant)this.entityData.get(VARIANT);
    }

    protected void doKnockback(LivingEntity target, DamageSource source) {
        float f;
        float modifier = this.getVariant().getAttributes().kb();
        if (modifier <= 0.0f) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            f = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)this.getWeaponItem(), (Entity)target, (DamageSource)source, (float)modifier);
        } else {
            f = 0.0f;
        }
        double d0 = f;
        if (d0 > 0.0) {
            double d1 = Math.max(0.0, 1.0 - target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale(d0 * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                target.push(vec3.x, 0.1, vec3.z);
            }
        }
    }

    public void setVariant(GlassArrowVariant variant) {
        this.entityData.set(VARIANT, (Object)variant);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString(VARIANT_STRING, PastelRegistries.GLASS_ARROW_VARIANT.getKey((Object)this.getVariant()).toString());
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        GlassArrowVariant variant = (GlassArrowVariant)PastelRegistries.GLASS_ARROW_VARIANT.get(ResourceLocation.tryParse((String)nbt.getString(VARIANT_STRING)));
        if (variant != null) {
            this.setVariant(variant);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientRemoval() {
        super.onClientRemoval();
        TrailRender render = this.getTrail();
        if (render != null) {
            TrailLeftoverHandler.addTrail((TrailRender)render, (MultiBufferSource)RenderHandler.createBufferSource(), (int)0xF000F0, (ColorGradient)this.getGradient());
            this.shouldRenderTrail = false;
        }
    }

    public ColorGradient getGradient() {
        return this.getVariant().getGradient();
    }

    public TrailRender getTrail() {
        if (!this.shouldRenderTrail) {
            return null;
        }
        if (this.trail == null) {
            this.trail = new TrailRender(this.position(), 60, 60, 0.15f, PastelCommon.locate("textures/misc/trail/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking();
        }
        return this.trail;
    }
}

