/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.api.entity.PackEntity;
import earth.terrarium.pastel.entity.entity.LizardEntity;
import earth.terrarium.pastel.registries.PastelItems;
import earth.terrarium.pastel.registries.PastelMobEffects;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OcelotAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EraserEntity
extends Spider
implements PackEntity<EraserEntity>,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(EraserEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private MobEffectInstance effectOnHit;
    @Nullable
    private EraserEntity leader;
    private int groupSize = 1;

    public EraserEntity(EntityType<? extends EraserEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createEraserAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FOLLOW_RANGE, 28.0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, LizardEntity.class, 6.0f, 1.0, 1.2));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new OcelotAttackGoal((Mob)this));
        this.goalSelector.addGoal(4, new PackEntity.FollowClanLeaderGoal<EraserEntity>(this));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    protected SoundEvent getAmbientSound() {
        return PastelSounds.ENTITY_ERASER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return PastelSounds.ENTITY_ERASER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return PastelSounds.ENTITY_ERASER_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(PastelSounds.ENTITY_ERASER_STEP, 0.15f, 1.0f);
    }

    public boolean canBeAffected(MobEffectInstance effect) {
        return super.canBeAffected(effect) && effect.getEffect() != PastelMobEffects.DEADLY_POISON;
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        RandomSource random = world.getRandom();
        this.effectOnHit = this.getRandomOnHitEffect();
        if (entityData == null) {
            entityData = new SwarmingSpiderData();
            ((SwarmingSpiderData)((Object)entityData)).setRandomEffect(random);
        }
        if (entityData instanceof SwarmingSpiderData) {
            SwarmingSpiderData swarmingSpiderData = (SwarmingSpiderData)((Object)entityData);
            Holder<MobEffect> statusEffect = swarmingSpiderData.effect;
            if (statusEffect != null) {
                this.addEffect(swarmingSpiderData.getEffectInstance());
            }
        }
        return entityData;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FROM_BUCKET, (Object)false);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean doHurtTarget(Entity target) {
        if (super.doHurtTarget(target)) {
            if (this.effectOnHit != null && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.addEffect(this.effectOnHit, (Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasOthersInGroup() {
        return this.groupSize > 1;
    }

    @Override
    @Nullable
    public EraserEntity getLeader() {
        return this.leader;
    }

    @Override
    public boolean isCloseEnoughToLeader() {
        return this.distanceToSqr((Entity)this.leader) <= 121.0;
    }

    @Override
    public void leaveGroup() {
        if (this.leader != null) {
            this.leader.decreaseGroupSize();
            this.leader = null;
        }
    }

    @Override
    public void moveTowardLeader() {
        if (this.hasLeader()) {
            this.getNavigation().moveTo((Entity)this.leader, 1.0);
        }
    }

    @Override
    public int getMaxGroupSize() {
        return super.getMaxSpawnClusterSize();
    }

    @Override
    public void joinGroupOf(EraserEntity groupLeader) {
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
    }

    @Override
    public int getGroupSize() {
        return this.groupSize;
    }

    protected void increaseGroupSize() {
        ++this.groupSize;
    }

    protected void decreaseGroupSize() {
        --this.groupSize;
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("FromBucket", this.fromBucket());
        this.putEffectOnHit(nbt);
    }

    private void putEffectOnHit(CompoundTag nbt) {
        if (this.effectOnHit != null) {
            nbt.put("EffectOnHit", this.effectOnHit.save());
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setFromBucket(nbt.getBoolean("FromBucket"));
        this.readEffectOnHit(nbt);
    }

    private void readEffectOnHit(CompoundTag nbt) {
        if (nbt.contains("EffectOnHit", 10)) {
            this.effectOnHit = MobEffectInstance.load((CompoundTag)nbt.getCompound("EffectOnHit"));
        }
    }

    public MobEffectInstance getRandomOnHitEffect() {
        Holder<MobEffect> statusEffect;
        Level world = this.level();
        Difficulty difficulty = this.level().getDifficulty();
        int amplifier = 0;
        switch (world.random.nextInt(30)) {
            case 1: {
                statusEffect = MobEffects.MOVEMENT_SPEED;
                amplifier = this.random.nextInt(2);
                break;
            }
            case 2: {
                statusEffect = MobEffects.DAMAGE_BOOST;
                amplifier = this.random.nextInt(2);
                break;
            }
            case 3: {
                statusEffect = MobEffects.CONFUSION;
                amplifier = 0;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                statusEffect = PastelMobEffects.STIFFNESS;
                amplifier = this.random.nextInt(2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                statusEffect = PastelMobEffects.FRENZY;
                amplifier = this.random.nextInt(2);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                statusEffect = PastelMobEffects.SCARRED;
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                statusEffect = PastelMobEffects.VULNERABILITY;
                amplifier = this.random.nextInt(2);
                break;
            }
            default: {
                statusEffect = PastelMobEffects.DEADLY_POISON;
                amplifier = this.random.nextInt(2);
            }
        }
        int duration = 120 * difficulty.getId();
        return new MobEffectInstance(statusEffect, duration, amplifier);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        return EraserEntity.bucketMobPickup(player, hand, this).orElse(super.mobInteract(player, hand));
    }

    static <T extends LivingEntity> Optional<InteractionResult> bucketMobPickup(Player player, InteractionHand hand, T entity) {
        ItemStack handStack = player.getItemInHand(hand);
        if (handStack.getItem() == Items.BUCKET && entity.isAlive()) {
            entity.playSound(((Bucketable)entity).getPickupSound(), 1.0f, 1.0f);
            ItemStack bucketedStack = ((Bucketable)entity).getBucketItemStack();
            ((Bucketable)entity).saveToBucketTag(bucketedStack);
            ItemStack exchangedStack = ItemUtils.createFilledResult((ItemStack)handStack, (Player)player, (ItemStack)bucketedStack, (boolean)false);
            player.setItemInHand(hand, exchangedStack);
            Level world = entity.level();
            if (!world.isClientSide) {
                CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, bucketedStack);
            }
            entity.discard();
            return Optional.of(InteractionResult.sidedSuccess((boolean)world.isClientSide));
        }
        return Optional.empty();
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    public void saveToBucketTag(ItemStack stack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)stack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)stack, this::putEffectOnHit);
    }

    public void loadFromBucketTag(CompoundTag nbt) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)nbt);
        this.readEffectOnHit(nbt);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)PastelItems.BUCKET_OF_ERASER.get());
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL;
    }

    public static class SwarmingSpiderData
    extends Spider.SpiderEffectsGroupData {
        public Holder<MobEffect> effect;
        public int amplifier = 0;

        public void setRandomEffect(RandomSource random) {
            switch (random.nextInt(5)) {
                case 0: {
                    this.effect = MobEffects.MOVEMENT_SPEED;
                    this.amplifier = random.nextInt(2);
                    break;
                }
                case 1: {
                    this.effect = MobEffects.DAMAGE_BOOST;
                    this.amplifier = random.nextInt(2);
                    break;
                }
                case 2: {
                    this.effect = MobEffects.REGENERATION;
                    this.amplifier = random.nextInt(2);
                    break;
                }
                case 3: {
                    this.effect = MobEffects.INVISIBILITY;
                    break;
                }
                default: {
                    this.effect = PastelMobEffects.MAGIC_ANNULATION;
                    this.amplifier = 5;
                }
            }
        }

        public MobEffectInstance getEffectInstance() {
            return new MobEffectInstance(this.effect, -1, this.amplifier);
        }
    }
}

