/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.helpers.data.ColorHelper;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelLootTables;
import earth.terrarium.pastel.registries.PastelSounds;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;

public class EggLayingWoolyPigEntity
extends Animal
implements Shearable {
    private static final Ingredient FOOD = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)PastelBlocks.AMARANTH_BUSHEL.get()});
    private static final int MAX_GRASS_TIMER = 40;
    private static final EntityDataAccessor<Byte> COLOR_AND_SHEARED = SynchedEntityData.defineId(EggLayingWoolyPigEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Boolean> HATLESS = SynchedEntityData.defineId(EggLayingWoolyPigEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Map<DyeColor, Integer> COLORS = new EnumMap(ColorHelper.VANILLA_DYE_COLORS.stream().collect(Collectors.toMap(Function.identity(), EggLayingWoolyPigEntity::getDyedColor)));
    private int eatGrassTimer;
    private EatBlockGoal eatGrassGoal;
    public int eggLayTime;

    public EggLayingWoolyPigEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.eggLayTime = this.random.nextInt(12000) + 12000;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        Level world = this.level();
        ItemStack handStack = player.getItemInHand(hand);
        Item item = handStack.getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (this.isAlive() && this.getColor() != dyeItem.getDyeColor()) {
                world.playSound(player, (Entity)this, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!world.isClientSide) {
                    this.setColor(dyeItem.getDyeColor());
                    handStack.shrink(1);
                }
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
        }
        if (handStack.is(Items.BUCKET) && !this.isBaby()) {
            player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
            ItemStack itemStack2 = ItemUtils.createFilledResult((ItemStack)handStack, (Player)player, (ItemStack)Items.MILK_BUCKET.getDefaultInstance());
            player.setItemInHand(hand, itemStack2);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide());
        }
        if (handStack.is(Tags.Items.TOOLS_SHEAR)) {
            if (!world.isClientSide() && this.readyForShearing()) {
                this.shear(SoundSource.PLAYERS);
                this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
                handStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public static AttributeSupplier.Builder createEggLayingWoolyPigAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public boolean isFood(ItemStack stack) {
        return FOOD.test(stack);
    }

    protected void registerGoals() {
        this.eatGrassGoal = new EatBlockGoal((Mob)this);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, (Predicate)FOOD, false));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(5, (Goal)this.eatGrassGoal);
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void handleEntityEvent(byte status) {
        if (status == 10) {
            this.eatGrassTimer = 40;
        } else {
            super.handleEntityEvent(status);
        }
    }

    protected void customServerAiStep() {
        this.eatGrassTimer = this.eatGrassGoal.getEatAnimationTick();
        super.customServerAiStep();
    }

    public void aiStep() {
        if (this.level().isClientSide()) {
            this.eatGrassTimer = Math.max(0, this.eatGrassTimer - 1);
        }
        if (!this.level().isClientSide() && this.isAlive() && !this.isBaby() && --this.eggLayTime <= 0) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)Items.EGG);
            this.eggLayTime = this.random.nextInt(6000) + 6000;
        }
        super.aiStep();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(COLOR_AND_SHEARED, (Object)0);
        builder.define(HATLESS, (Object)false);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        EggLayingWoolyPigEntity other = (EggLayingWoolyPigEntity)entity;
        EggLayingWoolyPigEntity child = (EggLayingWoolyPigEntity)((EntityType)PastelEntityTypes.EGG_LAYING_WOOLY_PIG.get()).create((Level)world);
        if (child != null) {
            child.setColor(this.getChildColor(this, other));
            if (world.random.nextInt(50) == 0) {
                child.setHatless(true);
            }
        }
        return child;
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("Sheared", this.isSheared());
        nbt.putBoolean("Hatless", this.isHatless());
        nbt.putByte("Color", (byte)this.getColor().getId());
        nbt.putInt("EggLayTime", this.eggLayTime);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setSheared(nbt.getBoolean("Sheared"));
        this.setHatless(nbt.getBoolean("Hatless"));
        this.setColor(DyeColor.byId((int)nbt.getByte("Color")));
        if (nbt.contains("EggLayTime")) {
            this.eggLayTime = nbt.getInt("EggLayTime");
        }
    }

    protected SoundEvent getAmbientSound() {
        return PastelSounds.ENTITY_EGG_LAYING_WOOLY_PIG_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return PastelSounds.ENTITY_EGG_LAYING_WOOLY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return PastelSounds.ENTITY_EGG_LAYING_WOOLY_DEATH;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(PastelSounds.ENTITY_EGG_LAYING_WOOLY_STEP, 0.15f, 1.0f);
    }

    public void ate() {
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    public float getNeckAngle(float delta) {
        if (this.eatGrassTimer <= 0) {
            return 0.0f;
        }
        if (this.eatGrassTimer >= 4 && this.eatGrassTimer <= 36) {
            return 1.0f;
        }
        return this.eatGrassTimer < 4 ? ((float)this.eatGrassTimer - delta) / 4.0f : -((float)(this.eatGrassTimer - 40) - delta) / 4.0f;
    }

    public float getHeadAngle(float delta) {
        if (this.eatGrassTimer > 4 && this.eatGrassTimer <= 36) {
            float f = ((float)(this.eatGrassTimer - 4) - delta) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.sin((float)(f * 28.7f));
        }
        return this.eatGrassTimer > 0 ? 0.62831855f : this.getXRot() * ((float)Math.PI / 180);
    }

    public void shear(SoundSource shearedSoundCategory) {
        Level world = this.level();
        world.playSound(null, (Entity)this, SoundEvents.SHEEP_SHEAR, shearedSoundCategory, 1.0f, 1.0f);
        this.setSheared(true);
        for (ItemStack droppedStack : this.getShearedStacks((ServerLevel)world)) {
            ItemEntity itemEntity = this.spawnAtLocation(droppedStack, 1.0f);
            if (itemEntity == null) continue;
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f), (double)(this.random.nextFloat() * 0.05f), (double)((this.random.nextFloat() - this.random.nextFloat()) * 0.1f)));
        }
    }

    public List<ItemStack> getShearedStacks(ServerLevel world) {
        LootParams.Builder builder = new LootParams.Builder(world).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position());
        LootTable lootTable = world.getServer().reloadableRegistries().getLootTable(PastelLootTables.EGG_LAYING_WOOLY_PIG_SHEARING);
        return lootTable.getRandomItems(builder.create(LootContextParamSets.GIFT));
    }

    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    public boolean isSheared() {
        return ((Byte)this.entityData.get(COLOR_AND_SHEARED) & 0x10) != 0;
    }

    public void setSheared(boolean sheared) {
        byte color = (Byte)this.entityData.get(COLOR_AND_SHEARED);
        if (sheared) {
            this.entityData.set(COLOR_AND_SHEARED, (Object)((byte)(color | 0x10)));
        } else {
            this.entityData.set(COLOR_AND_SHEARED, (Object)((byte)(color & 0xFFFFFFEF)));
        }
    }

    public boolean isHatless() {
        return (Boolean)this.entityData.get(HATLESS);
    }

    public void setHatless(boolean hatless) {
        this.entityData.set(HATLESS, (Object)hatless);
    }

    public static int getRgbColor(DyeColor dyeColor) {
        return COLORS.get(dyeColor);
    }

    private static int getDyedColor(DyeColor color) {
        if (color == DyeColor.WHITE) {
            return -1644826;
        }
        int i = color.getTextureDiffuseColor();
        return FastColor.ARGB32.color((int)255, (int)Mth.floor((float)((float)FastColor.ARGB32.red((int)i) * 0.75f)), (int)Mth.floor((float)((float)FastColor.ARGB32.green((int)i) * 0.75f)), (int)Mth.floor((float)((float)FastColor.ARGB32.blue((int)i) * 0.75f)));
    }

    public DyeColor getColor() {
        return DyeColor.byId((int)((Byte)this.entityData.get(COLOR_AND_SHEARED) & 0xF));
    }

    public void setColor(DyeColor color) {
        byte b = (Byte)this.entityData.get(COLOR_AND_SHEARED);
        this.entityData.set(COLOR_AND_SHEARED, (Object)((byte)(b & 0xF0 | color.getId() & 0xF)));
    }

    private DyeColor getChildColor(Animal firstParent, Animal secondParent) {
        Item item;
        Level world = this.level();
        DyeColor dyeColor = ((EggLayingWoolyPigEntity)firstParent).getColor();
        DyeColor dyeColor2 = ((EggLayingWoolyPigEntity)secondParent).getColor();
        CraftingInput craftingRecipeInput = EggLayingWoolyPigEntity.createChildColorRecipeInput(dyeColor, dyeColor2);
        Optional<Item> optionalItem = this.level().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftingRecipeInput, this.level()).map(recipe -> ((CraftingRecipe)recipe.value()).assemble((RecipeInput)craftingRecipeInput, (HolderLookup.Provider)this.level().registryAccess())).map(ItemStack::getItem);
        if (optionalItem.isPresent() && (item = optionalItem.get()) instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            return dyeItem.getDyeColor();
        }
        return world.random.nextBoolean() ? dyeColor : dyeColor2;
    }

    private static CraftingInput createChildColorRecipeInput(DyeColor firstColor, DyeColor secondColor) {
        return CraftingInput.of((int)2, (int)1, List.of(new ItemStack((ItemLike)DyeItem.byColor((DyeColor)firstColor)), new ItemStack((ItemLike)DyeItem.byColor((DyeColor)secondColor))));
    }

    private static TransientCraftingContainer createDyeMixingCraftingInventory(DyeColor firstColor, DyeColor secondColor) {
        TransientCraftingContainer craftingInventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

            public ItemStack quickMoveStack(Player player, int index) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player player) {
                return false;
            }
        }, 2, 1);
        craftingInventory.setItem(0, new ItemStack((ItemLike)DyeItem.byColor((DyeColor)firstColor)));
        craftingInventory.setItem(1, new ItemStack((ItemLike)DyeItem.byColor((DyeColor)secondColor)));
        return craftingInventory;
    }
}

