/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import earth.terrarium.pastel.blocks.block_flooder.BlockFlooderBlock;
import earth.terrarium.pastel.blocks.block_flooder.BlockFlooderBlockEntity;
import earth.terrarium.pastel.entity.PastelEntityTypes;
import earth.terrarium.pastel.registries.PastelBlocks;
import earth.terrarium.pastel.registries.PastelItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BlockFlooderProjectile
extends ThrowableItemProjectile {
    public BlockFlooderProjectile(EntityType<BlockFlooderProjectile> thrownItemEntityEntityType, Level world) {
        super(thrownItemEntityEntityType, world);
    }

    public BlockFlooderProjectile(Level world, LivingEntity owner) {
        super((EntityType)PastelEntityTypes.BLOCK_FLOODER_PROJECTILE.get(), owner, world);
    }

    public BlockFlooderProjectile(Level world, double x, double y, double z) {
        super((EntityType)PastelEntityTypes.BLOCK_FLOODER_PROJECTILE.get(), x, y, z, world);
    }

    protected Item getDefaultItem() {
        return (Item)PastelItems.BLOCK_FLOODER.get();
    }

    private ParticleOptions getParticleParameters() {
        ItemStack itemStack = this.getItem();
        return itemStack.isEmpty() ? ParticleTypes.ITEM_SNOWBALL : new ItemParticleOption(ParticleTypes.ITEM, itemStack);
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            ParticleOptions particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleEffect, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        Level world = this.level();
        if (!world.isClientSide()) {
            Entity entity;
            BlockPos landingPos;
            world.broadcastEntityEvent((Entity)this, (byte)3);
            if (hitResult.getType() == HitResult.Type.BLOCK && BlockFlooderBlock.isReplaceableBlock(world, landingPos = this.getCorrectedBlockPos(hitResult.getLocation())) && (entity = this.getOwner()) instanceof Player) {
                Player playerEntityOwner = (Player)entity;
                world.setBlockAndUpdate(landingPos, ((Block)PastelBlocks.BLOCK_FLOODER.get()).defaultBlockState());
                BlockEntity blockEntity = world.getBlockEntity(landingPos);
                if (blockEntity instanceof BlockFlooderBlockEntity) {
                    BlockFlooderBlockEntity blockFlooderBlockEntity = (BlockFlooderBlockEntity)blockEntity;
                    blockFlooderBlockEntity.setOwnerUUID(playerEntityOwner.getUUID());
                    blockFlooderBlockEntity.setSourcePos(landingPos);
                }
                this.discard();
            }
        }
    }

    public BlockPos getCorrectedBlockPos(Vec3 hitPos) {
        BlockPos hitBlockPos = BlockPos.containing((Position)hitPos);
        if (this.level().getBlockState(hitBlockPos).isRedstoneConductor((BlockGetter)this.level(), hitBlockPos)) {
            if (hitPos.x() % 1.0 < 0.05) {
                return hitBlockPos.offset(-1, 0, 0);
            }
            if (hitPos.y() % 1.0 < 0.05) {
                return hitBlockPos.offset(0, -1, 0);
            }
            if (hitPos.z() % 1.0 < 0.05) {
                return hitBlockPos.offset(0, 0, -1);
            }
            if (hitPos.x() % 1.0 < 0.95) {
                return hitBlockPos.offset(1, 0, 0);
            }
            if (hitPos.y() % 1.0 < 0.95) {
                return hitBlockPos.offset(0, 1, 0);
            }
            if (hitPos.z() % 1.0 < 0.95) {
                return hitBlockPos.offset(0, 0, 1);
            }
        }
        return hitBlockPos;
    }
}

