/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.pastel.entity.entity;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.databank.misc.TrailLeftoverHandler;
import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import earth.terrarium.pastel.PastelCommon;
import earth.terrarium.pastel.helpers.data.CodecHelper;
import earth.terrarium.pastel.helpers.enchantments.Ench;
import earth.terrarium.pastel.mixin.accessors.TridentEntityAccessor;
import earth.terrarium.pastel.registries.PastelSounds;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class BidentBaseEntity
extends ThrownTrident {
    protected static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.defineId(BidentBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private boolean shouldRenderTrail = true;
    private TrailRender trail;

    public BidentBaseEntity(EntityType<? extends ThrownTrident> entityType, Level world) {
        super(entityType, world);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STACK, (Object)Items.AIR.getDefaultInstance());
    }

    public void setPickupItemStack(ItemStack stack) {
        this.setTrackedStack(stack.copy());
        super.setPickupItemStack(stack);
        this.entityData.set(TridentEntityAccessor.getLoyalty(), (Object)((byte)Ench.getLevel((HolderLookup.Provider)this.level().registryAccess(), (ResourceKey<Enchantment>)Enchantments.LOYALTY, stack)));
        this.entityData.set(TridentEntityAccessor.getEnchanted(), (Object)stack.hasFoil());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return PastelSounds.BIDENT_HIT_GROUND;
    }

    public ItemStack getTrackedStack() {
        return (ItemStack)this.entityData.get(STACK);
    }

    public void setTrackedStack(ItemStack stack) {
        this.entityData.set(STACK, (Object)stack);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(STACK, (Object)CodecHelper.fromNbt(ItemStack.CODEC, nbt.get("item"), ItemStack.EMPTY));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
    }

    public AABB makeBoundingBox() {
        return super.makeBoundingBox();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onClientRemoval() {
        super.onClientRemoval();
        TrailRender render = this.getTrail();
        if (render != null) {
            TrailLeftoverHandler.addTrail((TrailRender)render, (MultiBufferSource)RenderHandler.createBufferSource(), (int)0xF000F0, (ColorGradient)this.getGradient());
            this.shouldRenderTrail = false;
        }
    }

    public ColorGradient getGradient() {
        return new ColorGradient(new Color(0xCCFFF4), new Color(42631)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }

    public TrailRender getTrail() {
        if (!this.shouldRenderTrail) {
            return null;
        }
        if (this.trail == null) {
            this.trail = new TrailRender(this.position(), 20, 20, 0.15f, PastelCommon.locate("textures/misc/trail/trail.png"), RenderTypeHandler::transparent).setShrink(true).startTicking();
        }
        return this.trail;
    }
}

